/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.Index;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;
import org.tinspin.index.rtree.RTreeNodeLeaf;

public class RTreeQueryKnn<T>
implements Index.BoxIteratorKnn<T> {
    private static final Index.BEComparator COMP = new Index.BEComparator();
    private final RTree<T> tree;
    private double[] center;
    private Iterator<Index.BoxEntryKnn<T>> iter;
    private BoxDistance dist;
    private final ArrayList<Index.BoxEntryKnn<T>> candidates = new ArrayList();
    private final ArrayList<Index.BoxEntryKnn<Object>> pool = new ArrayList();
    private final PriorityQueue<Index.BoxEntryKnn<Object>> queue = new PriorityQueue(COMP);

    public RTreeQueryKnn(RTree<T> tree, double[] center, int k, BoxDistance dist) {
        this.tree = tree;
        this.reset(center, k, dist == null ? BoxDistance.EDGE : dist);
    }

    @Override
    public RTreeQueryKnn<T> reset(double[] center, int k) {
        this.reset(center, k, null);
        return this;
    }

    public void reset(double[] center, int k, BoxDistance dist) {
        if (dist != null) {
            this.dist = dist;
        }
        if (this.dist != BoxDistance.EDGE) {
            System.err.println("This distance iterator only works for EDGE distance");
        }
        this.center = center;
        this.pool.addAll(this.queue);
        this.queue.clear();
        this.candidates.clear();
        this.candidates.ensureCapacity(k);
        if (k <= 0 || this.tree.size() == 0) {
            this.iter = this.candidates.iterator();
            return;
        }
        this.search(k);
        this.iter = this.candidates.iterator();
    }

    private void search(int k) {
        RTreeNode<T> eRoot = this.tree.getRoot();
        double dRoot = this.dist(this.center, eRoot.min(), eRoot.max());
        this.queue.add(this.createEntry(eRoot.min(), eRoot.max(), eRoot, dRoot));
        while (!this.queue.isEmpty()) {
            double d;
            RTreeNode e2;
            int i;
            ArrayList entries;
            Index.BoxEntryKnn<Object> candidate = this.queue.poll();
            Object o = candidate.value();
            if (!(o instanceof RTreeNode)) {
                this.candidates.add(candidate);
                if (this.candidates.size() < k) continue;
                return;
            }
            if (o instanceof RTreeNodeLeaf) {
                entries = ((RTreeNodeLeaf)o).getEntries();
                for (i = 0; i < entries.size(); ++i) {
                    e2 = entries.get(i);
                    d = this.dist(this.center, e2.min(), e2.max());
                    this.queue.add(this.createEntry(e2.min(), e2.max(), e2.value(), d));
                }
                this.pool.add(candidate);
                continue;
            }
            entries = ((RTreeNodeDir)o).getChildren();
            for (i = 0; i < entries.size(); ++i) {
                e2 = (RTreeNode)entries.get(i);
                d = this.dist(this.center, e2.min(), e2.max());
                this.queue.add(this.createEntry(e2.min(), e2.max(), e2, d));
            }
            this.pool.add(candidate);
        }
    }

    private Index.BoxEntryKnn<Object> createEntry(double[] min, double[] max, Object val, double dist) {
        if (this.pool.isEmpty()) {
            return new Index.BoxEntryKnn<Object>(min, max, val, dist);
        }
        Index.BoxEntryKnn<Object> e = this.pool.remove(this.pool.size() - 1);
        e.set(min, max, val, dist);
        return e;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Index.BoxEntryKnn<T> next() {
        return this.iter.next();
    }

    private double dist(double[] center, double[] min, double[] max) {
        this.tree.incNDistKNN();
        return this.dist.dist(center, min, max);
    }
}

