/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.tinspin.index.Index;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;
import org.tinspin.index.rtree.RTreeNodeLeaf;

public class STRLoader<T> {
    private int nNodes = 0;
    private int size = 0;
    private RTreeNode<T> root;
    private int depth;

    public RTreeNode<T> getRoot() {
        return this.root;
    }

    public int getNNodes() {
        return this.nNodes;
    }

    public int getSize() {
        return this.size;
    }

    public int getDepth() {
        return this.depth;
    }

    public void load(Entry<T>[] entries) {
        int dims = entries[0].min().length;
        int N = entries.length;
        int M = 10;
        CenterComp comp = new CenterComp();
        this.sortChunks(entries, dims, M, comp);
        RTreeNode[] nodes = new RTreeNode[(int)Math.ceil((double)N / (double)M)];
        int posNode = 0;
        RTreeNodeLeaf<T> node = null;
        for (int i = 0; i < entries.length; ++i) {
            if (i % M == 0) {
                node = new RTreeNodeLeaf<T>(dims);
                nodes[posNode++] = node;
            }
            ((RTreeNode)node).addEntry(entries[i]);
        }
        this.nNodes += nodes.length;
        this.depth = 1;
        if (nodes.length == 1) {
            this.root = nodes[0];
            this.nNodes = 1;
            this.size = entries.length;
            return;
        }
        int MDir = 10;
        RTreeNodeDir[] parentNodes = null;
        do {
            ++this.depth;
            parentNodes = new RTreeNodeDir[(int)Math.ceil((double)nodes.length / (double)MDir)];
            this.sortChunks(nodes, dims, MDir, comp);
            this.nNodes += parentNodes.length;
            RTreeNodeDir p = null;
            int posParent = 0;
            for (int i = 0; i < nodes.length; ++i) {
                if (i % MDir == 0) {
                    p = new RTreeNodeDir(dims);
                    parentNodes[posParent++] = p;
                }
                p.addEntry(nodes[i]);
            }
            nodes = parentNodes;
        } while (parentNodes.length > 1);
        this.root = parentNodes[0];
        this.size = entries.length;
    }

    private void verify(Entry<T>[] entries) {
        System.err.println("Verifying bulkload");
        int n = this.verifyNode(this.root, this.depth - 1);
        if (n != entries.length) {
            throw new IllegalStateException("n=" + n + "/" + entries.length);
        }
    }

    private int verifyNode(RTreeNode<T> node, int level) {
        System.out.println("Checking node: " + node);
        ArrayList<Entry<T>> el = node.getEntries();
        int nEntries = 0;
        int nNodes = 0;
        int dim = el.get(0).min().length;
        double[] mbbMin = new double[dim];
        double[] mbbMax = new double[dim];
        Arrays.fill(mbbMin, Double.POSITIVE_INFINITY);
        Arrays.fill(mbbMax, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < el.size(); ++i) {
            Index.BoxEntry e = el.get(i);
            if (!Entry.calcIncludes(node.min(), node.max(), e.min(), e.max())) {
                throw new IllegalStateException();
            }
            for (int d = 0; d < dim; ++d) {
                if (e.min()[d] < mbbMin[d]) {
                    mbbMin[d] = e.min()[d];
                }
                if (!(e.max()[d] > mbbMax[d])) continue;
                mbbMax[d] = e.max()[d];
            }
            if (level == 0) {
                if (e instanceof RTreeNode) {
                    throw new IllegalStateException();
                }
                ++nEntries;
                continue;
            }
            ++nNodes;
            if (level == 1 && !(e instanceof RTreeNodeLeaf)) {
                throw new IllegalStateException();
            }
            if (level > 1 && !(e instanceof RTreeNodeDir)) {
                throw new IllegalStateException();
            }
            RTreeNode subNode = (RTreeNode)e;
            if (subNode.getParent() != node) {
                throw new IllegalStateException();
            }
            nEntries += this.verifyNode(subNode, level - 1);
        }
        if (!Arrays.equals(mbbMin, node.min()) || !Arrays.equals(mbbMax, node.max())) {
            throw new IllegalStateException();
        }
        return nEntries;
    }

    private void sortChunks(Index.BoxEntry<T>[] entries, int dims, int M, CenterComp comp) {
        comp.setDim(0);
        Arrays.sort(entries, comp);
        int nToSplit = entries.length;
        for (int d = 1; d < dims; ++d) {
            int nodesPerAxis = (int)Math.pow(nToSplit / M, 1.0 / (double)(dims - d + 1));
            comp.setDim(d);
            int chunkSize = (int)Math.ceil(Math.pow(nodesPerAxis, dims - d) * (double)M);
            if (chunkSize < M) break;
            for (int pos = 0; pos < entries.length; pos += chunkSize) {
                int end = Math.min(pos + chunkSize, entries.length);
                Arrays.sort(entries, pos, end, comp);
            }
            nToSplit /= nodesPerAxis;
        }
    }

    private class CenterComp
    implements Comparator<Index.BoxEntry<T>> {
        int dim = -1;

        private CenterComp() {
        }

        void setDim(int dim) {
            this.dim = dim;
        }

        @Override
        public int compare(Index.BoxEntry<T> o1, Index.BoxEntry<T> o2) {
            double c2;
            double c1 = o1.max()[this.dim] + o1.min()[this.dim];
            return c1 < (c2 = o2.max()[this.dim] + o2.min()[this.dim]) ? -1 : (c1 > c2 ? 1 : 0);
        }
    }
}

