/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.tinspin.index.Stats;

public interface Index {
    public int getDims();

    public int size();

    public void clear();

    public Stats getStats();

    public int getNodeCount();

    public int getDepth();

    public String toStringTree();

    public static class BEComparator
    implements Comparator<BoxEntryKnn<?>> {
        @Override
        public int compare(BoxEntryKnn<?> o1, BoxEntryKnn<?> o2) {
            return Double.compare(o1.dist, o2.dist);
        }
    }

    public static class PEComparator
    implements Comparator<PointEntryKnn<?>> {
        @Override
        public int compare(PointEntryKnn<?> o1, PointEntryKnn<?> o2) {
            return Double.compare(o1.dist, o2.dist);
        }
    }

    @FunctionalInterface
    public static interface BoxFilterKnn<T> {
        public boolean test(BoxEntry<T> var1, double var2);
    }

    @FunctionalInterface
    public static interface PointFilterKnn<T> {
        public boolean test(PointEntry<T> var1, double var2);
    }

    public static class BoxEntryKnn<T>
    extends BoxEntry<T> {
        private double dist;

        public BoxEntryKnn(double[] min, double[] max, T value, double dist) {
            super(min, max, value);
            this.dist = dist;
        }

        public BoxEntryKnn(BoxEntry<T> entry, double dist) {
            super(entry.min(), entry.max(), entry.value());
            this.dist = dist;
        }

        public double dist() {
            return this.dist;
        }

        public void set(double[] min, double[] max, T val, double dist) {
            super.set(min, max, val);
            this.dist = dist;
        }
    }

    public static class BoxEntry<T> {
        private double[] min;
        private double[] max;
        private T val;

        public BoxEntry(double[] min, double[] max, T val) {
            this.min = min;
            this.max = max;
            this.val = val;
        }

        public double[] min() {
            return this.min;
        }

        public double[] max() {
            return this.max;
        }

        @Deprecated
        double[] lower() {
            return this.min;
        }

        @Deprecated
        double[] upper() {
            return this.max;
        }

        public T value() {
            return this.val;
        }

        public void set(double[] min, double[] max) {
            this.min = min;
            this.max = max;
        }

        public void set(double[] min, double[] max, T val) {
            this.set(min, max);
            this.val = val;
        }
    }

    public static class PointEntryKnn<T>
    extends PointEntry<T> {
        private double dist;

        public PointEntryKnn(double[] point, T value, double dist) {
            super(point, value);
            this.dist = dist;
        }

        public PointEntryKnn(PointEntry<T> entry, double dist) {
            super(entry.point(), entry.value());
            this.dist = dist;
        }

        public double dist() {
            return this.dist;
        }

        public void set(double[] point, T value, double dist) {
            super.set(point, value);
            this.dist = dist;
        }

        public void set(PointEntry<T> entry, double dist) {
            super.set(entry.point(), entry.value);
            this.dist = dist;
        }
    }

    public static class PointEntry<T> {
        private double[] point;
        private T value;

        public PointEntry(double[] point, T value) {
            this.point = point;
            this.value = value;
        }

        public double[] point() {
            return this.point;
        }

        public T value() {
            return this.value;
        }

        public String toString() {
            return Arrays.toString(this.point) + ";v=" + this.value;
        }

        public void setPoint(double[] point) {
            this.point = point;
        }

        protected void set(double[] point, T value) {
            this.point = point;
            this.value = value;
        }
    }

    public static interface BoxIteratorKnn<T>
    extends QueryIteratorKnn<BoxEntryKnn<T>> {
    }

    public static interface PointIteratorKnn<T>
    extends QueryIteratorKnn<PointEntryKnn<T>> {
    }

    public static interface QueryIteratorKnn<T>
    extends Iterator<T> {
        public QueryIteratorKnn<T> reset(double[] var1, int var2);
    }

    public static interface BoxIterator<T>
    extends QueryIterator<BoxEntry<T>> {
    }

    public static interface PointIterator<T>
    extends QueryIterator<PointEntry<T>> {
    }

    public static interface QueryIterator<T>
    extends Iterator<T> {
        public QueryIterator<T> reset(double[] var1, double[] var2);
    }
}

