/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.array;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.BoxMap;
import org.tinspin.index.BoxMultimap;
import org.tinspin.index.Index;
import org.tinspin.index.Stats;
import org.tinspin.index.util.BoxIteratorWrapper;

public class RectArray<T>
implements BoxMap<T>,
BoxMultimap<T> {
    private final double[][] phc;
    private final int dims;
    private int N;
    private int size;
    private final Index.BoxEntry<T>[] values;
    private int insPos = 0;
    private static final Index.BEComparator COMP = new Index.BEComparator();

    public RectArray(int dims, int size) {
        this.N = size;
        this.size = 0;
        this.dims = dims;
        this.phc = new double[2 * this.N][dims];
        this.values = new Index.BoxEntry[this.N];
    }

    @Override
    public void insert(double[] lower, double[] upper, T value) {
        System.arraycopy(lower, 0, this.phc[this.insPos * 2], 0, this.dims);
        System.arraycopy(upper, 0, this.phc[this.insPos * 2 + 1], 0, this.dims);
        this.values[this.insPos] = new Index.BoxEntryKnn<T>(lower, upper, value, -1.0);
        ++this.insPos;
        ++this.size;
    }

    @Override
    public T remove(double[] lower, double[] upper) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], lower) || !this.eq(this.phc[i * 2 + 1], upper)) continue;
            this.phc[i * 2] = null;
            this.phc[i * 2 + 1] = null;
            --this.size;
            return this.values[i].value();
        }
        return null;
    }

    @Override
    public boolean remove(double[] lower, double[] upper, T value) {
        return this.removeIf(lower, upper, e -> Objects.equals(value, e.value()));
    }

    @Override
    public boolean removeIf(double[] lower, double[] upper, Predicate<Index.BoxEntry<T>> condition) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], lower) || !this.eq(this.phc[i * 2 + 1], upper) || !condition.test(this.values[i])) continue;
            this.phc[i * 2] = null;
            this.phc[i * 2 + 1] = null;
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public T update(double[] lo1, double[] up1, double[] lo2, double[] up2) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i * 2], lo1) || !this.eq(this.phc[i * 2 + 1], up1)) continue;
            System.arraycopy(lo2, 0, this.phc[i * 2], 0, this.dims);
            System.arraycopy(up2, 0, this.phc[i * 2 + 1], 0, this.dims);
            return this.values[i].value();
        }
        return null;
    }

    @Override
    public boolean contains(double[] min, double[] max) {
        return this.queryExact(min, max) != null;
    }

    @Override
    public boolean update(double[] lo1, double[] up1, double[] lo2, double[] up2, T value) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i * 2], lo1) || !this.eq(this.phc[i * 2 + 1], up1) || !this.eq(this.phc[i * 2], lo1) || !this.eq(this.phc[i * 2 + 1], up1) || !Objects.equals(value, this.values[i].value())) continue;
            System.arraycopy(lo2, 0, this.phc[i * 2], 0, this.dims);
            System.arraycopy(up2, 0, this.phc[i * 2 + 1], 0, this.dims);
            return true;
        }
        return false;
    }

    @Override
    public T queryExact(double[] lower, double[] upper) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], lower) || !this.eq(this.phc[i * 2 + 1], upper)) continue;
            return this.values[i].value();
        }
        return null;
    }

    @Override
    public boolean contains(double[] lower, double[] upper, T value) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], lower) || !this.eq(this.phc[i * 2 + 1], upper) || !Objects.equals(value, this.values[i].value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Index.BoxIterator<T> queryExactBox(double[] lower, double[] upper) {
        return new BoxIteratorWrapper(lower, upper, (low, upp) -> {
            ArrayList<Index.BoxEntry<T>> result = new ArrayList<Index.BoxEntry<T>>();
            for (int i = 0; i < this.N; ++i) {
                if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], (double[])low) || !this.eq(this.phc[i * 2 + 1], (double[])upp)) continue;
                result.add(this.values[i]);
            }
            return result.iterator();
        });
    }

    private boolean eq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private boolean geq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < b[i])) continue;
            return false;
        }
        return true;
    }

    private boolean leq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > b[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Index.BoxIterator<T> queryIntersect(double[] min, double[] max) {
        return new BoxIteratorWrapper(min, max, (lower, upper) -> {
            ArrayList<Index.BoxEntry<T>> results = new ArrayList<Index.BoxEntry<T>>();
            for (int i = 0; i < this.N; ++i) {
                if (!this.leq(this.phc[i * 2], (double[])upper) || !this.geq(this.phc[i * 2 + 1], (double[])lower)) continue;
                results.add(this.values[i]);
            }
            return results.iterator();
        });
    }

    @Override
    public Index.BoxEntryKnn<T> query1nn(double[] center) {
        return (Index.BoxEntryKnn)this.queryKnn(center, 1).next();
    }

    @Override
    public Index.BoxIterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Index.BoxIteratorKnn<T> queryKnn(double[] center, int k) {
        return new AQueryIteratorKnn(center, k);
    }

    @Override
    public Index.BoxIteratorKnn<T> queryKnn(double[] center, int k, BoxDistance distFn) {
        return null;
    }

    private static double distREdge(double[] center, double[] rLower, double[] rUpper) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = 0.0;
            if (center[i] > rUpper[i]) {
                d = center[i] - rUpper[i];
            } else if (center[i] < rLower[i]) {
                d = rLower[i] - center[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public String toString() {
        return "NaiveArray";
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i;
        for (i = 0; i < this.N; ++i) {
            this.values[i] = null;
        }
        for (i = 0; i < 2 * this.N; ++i) {
            this.phc[i] = null;
        }
        this.N = 0;
        this.size = 0;
    }

    @Override
    public Stats getStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public String toStringTree() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.N; ++i) {
            s.append(Arrays.toString(this.phc[i * 2])).append("/").append(Arrays.toString(this.phc[i * 2 + 1])).append(" v=").append(this.values[i]);
        }
        return s.toString();
    }

    private class AQueryIteratorKnn
    implements Index.BoxIteratorKnn<T> {
        private Iterator<Index.BoxEntryKnn<T>> it;

        public AQueryIteratorKnn(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Index.BoxEntryKnn<T> next() {
            return this.it.next();
        }

        public AQueryIteratorKnn reset(double[] center, int k) {
            this.it = this.knnQuery(center, k).iterator();
            return this;
        }

        private ArrayList<Index.BoxEntryKnn<T>> knnQuery(double[] center, int k) {
            ArrayList ret = new ArrayList(k);
            for (int i = 0; i < RectArray.this.phc.length / 2; ++i) {
                double[] min = RectArray.this.phc[i * 2];
                double[] max = RectArray.this.phc[i * 2 + 1];
                double dist = RectArray.distREdge(center, min, max);
                if (ret.size() < k) {
                    ret.add(new Index.BoxEntryKnn(min, max, RectArray.this.values[i].value(), dist));
                    ret.sort(COMP);
                    continue;
                }
                if (!(ret.get(k - 1).dist() > dist)) continue;
                ret.remove(k - 1);
                ret.add(new Index.BoxEntryKnn(min, max, RectArray.this.values[i].value(), dist));
                ret.sort(COMP);
            }
            return ret;
        }
    }
}

