/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.kdtree;

import java.util.Arrays;
import org.tinspin.index.Index;
import org.tinspin.index.kdtree.KDTree;

public class Node<T>
extends Index.PointEntry<T> {
    private Node<T> left;
    private Node<T> right;
    private final int dim;

    Node(double[] p, T value, int dim, boolean defensiveKeyCopy) {
        super(defensiveKeyCopy ? (double[])p.clone() : p, value);
        this.dim = dim;
    }

    Node<T> getClosestNodeOrAddPoint(double[] p, T value, int dims, boolean defensiveKeyCopy) {
        if (p[this.dim] >= this.point()[this.dim]) {
            if (this.right != null) {
                return this.right;
            }
            this.right = new Node<T>(p, value, (this.dim + 1) % dims, defensiveKeyCopy);
            return null;
        }
        if (this.left != null) {
            return this.left;
        }
        this.left = new Node<T>(p, value, (this.dim + 1) % dims, defensiveKeyCopy);
        return null;
    }

    Node<T> getLo() {
        return this.left;
    }

    Node<T> getHi() {
        return this.right;
    }

    void setLeft(Node<T> left) {
        this.left = left;
    }

    void setRight(Node<T> right) {
        this.right = right;
    }

    void checkNode(KDTree.KDStats s, int depth) {
        ++s.nNodes;
        if (depth > s.maxDepth) {
            s.maxDepth = depth;
        }
        if (this.left != null) {
            this.left.checkNode(s, depth + 1);
        }
        if (this.right != null) {
            this.right.checkNode(s, depth + 1);
        }
    }

    @Override
    public String toString() {
        return "center=" + Arrays.toString(this.point()) + " " + System.identityHashCode(this);
    }

    boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    int getDim() {
        return this.dim;
    }

    @Override
    public void set(double[] point, T value) {
        super.set(point, value);
    }
}

