/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube2;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.PointMap;
import org.tinspin.index.PointMultimap;
import org.tinspin.index.Stats;
import org.tinspin.index.qthypercube2.QIterator0;
import org.tinspin.index.qthypercube2.QIterator1;
import org.tinspin.index.qthypercube2.QIterator2;
import org.tinspin.index.qthypercube2.QIteratorKnn;
import org.tinspin.index.qthypercube2.QNode;
import org.tinspin.index.qthypercube2.QUtil;
import org.tinspin.index.util.StringBuilderLn;

public class QuadTreeKD2<T>
implements PointMap<T>,
PointMultimap<T> {
    public static boolean ENABLE_HCI_1 = true;
    public static boolean ENABLE_HCI_2 = true;
    private static final int MAX_DEPTH = 50;
    public static final boolean DEBUG = false;
    private static final int DEFAULT_MAX_NODE_SIZE = 10;
    private static final double INITIAL_RADIUS = Double.MAX_VALUE;
    private final int dims;
    private final int maxNodeSize;
    private QNode<T> root = null;
    private int size = 0;

    private QuadTreeKD2(int dims, int maxNodeSize) {
        this.dims = dims;
        this.maxNodeSize = maxNodeSize;
    }

    public static <T> QuadTreeKD2<T> create(int dims) {
        int maxNodeSize = 10;
        if (2 * dims > 10) {
            maxNodeSize = 2 * dims;
        }
        return new QuadTreeKD2<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeKD2<T> create(int dims, int maxNodeSize) {
        return new QuadTreeKD2<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeKD2<T> create(int dims, int maxNodeSize, double[] center, double radius) {
        QuadTreeKD2<T> t = new QuadTreeKD2<T>(dims, maxNodeSize);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0 but was " + radius);
        }
        t.root = new QNode(Arrays.copyOf(center, center.length), radius);
        return t;
    }

    @Override
    public void insert(double[] key, T value) {
        ++this.size;
        Index.PointEntry<T> e = new Index.PointEntry<T>(key, value);
        if (this.root == null) {
            this.root = new QNode((double[])key.clone(), Double.MAX_VALUE);
        }
        if (this.root.getRadius() == Double.MAX_VALUE) {
            this.adjustRootSize(key);
        }
        this.ensureCoverage(e);
        int depth = 0;
        for (QNode<T> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
        }
    }

    private void adjustRootSize(double[] key) {
        if (!this.root.isLeaf() || this.root.getValueCount() == 0) {
            return;
        }
        if (this.root.getRadius() == Double.MAX_VALUE) {
            double dist = PointDistance.L2.dist(key, this.root.getCenter());
            if (dist > 0.0) {
                this.root.adjustRadius(2.0 * dist);
            } else if (this.root.getValueCount() >= this.maxNodeSize - 1) {
                this.root.adjustRadius(1000.0);
            }
        }
    }

    @Override
    public boolean contains(double[] key) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(key, entry -> true) != null;
    }

    @Override
    public T queryExact(double[] key) {
        if (this.root == null) {
            return null;
        }
        Index.PointEntry<T> e = this.root.getExact(key, entry -> true);
        return e == null ? null : (T)e.value();
    }

    @Override
    public boolean contains(double[] key, T value) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(key, e -> Objects.equals(value, e.value())) != null;
    }

    @Override
    public T remove(double[] key) {
        if (this.root == null) {
            return null;
        }
        Index.PointEntry<T> e = this.root.remove(null, key, this.maxNodeSize, x -> true);
        if (e == null) {
            return null;
        }
        --this.size;
        return e.value();
    }

    @Override
    public boolean remove(double[] key, T value) {
        return this.removeIf(key, e -> Objects.equals(e.value(), value));
    }

    @Override
    public boolean removeIf(double[] key, Predicate<Index.PointEntry<T>> condition) {
        if (this.root == null) {
            return false;
        }
        Index.PointEntry<T> e = this.root.remove(null, key, this.maxNodeSize, condition);
        if (e == null) {
            return false;
        }
        --this.size;
        return true;
    }

    @Override
    public T update(double[] oldKey, double[] newKey) {
        return this.updateIf(oldKey, newKey, e -> true);
    }

    @Override
    public boolean update(double[] oldKey, double[] newKey, T value) {
        return this.updateIf(oldKey, newKey, e -> Objects.equals(e.value(), value)) != null;
    }

    public T updateIf(double[] oldKey, double[] newKey, Predicate<Index.PointEntry<T>> condition) {
        if (this.root == null) {
            return null;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        Index.PointEntry<T> e = this.root.update(null, oldKey, newKey, this.maxNodeSize, requiresReinsert, 0, 50, condition);
        if (e == null) {
            return null;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            int depth = 0;
            for (QNode<T> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
            }
        }
        return e.value();
    }

    private void ensureCoverage(Index.PointEntry<T> e) {
        double[] p = e.point();
        while (!QUtil.fitsIntoNode(e.point(), this.root.getCenter(), this.root.getRadius())) {
            double[] center = this.root.getCenter();
            double radius = this.root.getRadius();
            double[] center2 = new double[center.length];
            double radius2 = radius * 2.0;
            int subNodePos = 0;
            for (int d = 0; d < center.length; ++d) {
                subNodePos <<= 1;
                if (p[d] < center[d] - radius) {
                    center2[d] = center[d] - radius;
                    subNodePos |= 1;
                    continue;
                }
                center2[d] = center[d] + radius;
            }
            this.root = new QNode<T>(center2, radius2, this.root, subNodePos);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    @Override
    public Index.PointIterator<T> queryExactPoint(double[] point) {
        return this.query(point, point);
    }

    @Override
    public Index.PointIterator<T> query(double[] min, double[] max) {
        if (ENABLE_HCI_2) {
            return new QIterator2(this, min, max);
        }
        if (ENABLE_HCI_1) {
            return new QIterator1(this, min, max);
        }
        return new QIterator0(this, min, max);
    }

    @Override
    public Index.PointEntryKnn<T> query1nn(double[] center) {
        return PointMap.super.query1nn(center);
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k, PointDistance distFn) {
        return new QIteratorKnn<T>(this.root, k, center, distFn, (e, d) -> true);
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, QNode<T> node, int depth, int posInParent) {
        Object prefix = ".".repeat(depth);
        sb.append((String)prefix + posInParent + " d=" + depth);
        sb.append(" " + Arrays.toString(node.getCenter()));
        sb.appendLn("/" + node.getRadius());
        prefix = (String)prefix + " ";
        for (int i = 0; i < node.getEntries().length; ++i) {
            Object o = node.getEntries()[i];
            if (o instanceof QNode) {
                QNode sub = (QNode)o;
                this.toStringTree(sb, sub, depth + 1, i);
                continue;
            }
            if (o == null) continue;
            Index.PointEntry e = (Index.PointEntry)o;
            sb.append((String)prefix).append(Arrays.toString(e.point()));
            sb.append(" v=").append(e.value()).appendLn();
        }
    }

    public String toString() {
        return "QuadTreeKD2;maxNodeSize=" + this.maxNodeSize + ";maxDepth=50;DEBUG=false;center/radius=" + (String)(this.root == null ? "null" : Arrays.toString(this.root.getCenter()) + "/" + this.root.getRadius()) + ";HCI-1/2=" + ENABLE_HCI_1 + "/" + ENABLE_HCI_2;
    }

    @Override
    public QStats getStats() {
        QStats s = new QStats(this.dims);
        if (this.root != null) {
            this.root.checkNode(s, null, 0);
        }
        return s;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public Index.PointIterator<T> iterator() {
        if (this.root == null) {
            return this.query(new double[this.dims], new double[this.dims]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k) {
        return this.queryKnn(center, k, PointDistance.L2);
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    protected QNode<T> getRoot() {
        return this.root;
    }

    public static class QStats
    extends Stats {
        final int[] histoValues = new int[100];
        final int[] histoSubs;
        static final int HISTO_MAX = 1025;

        public QStats(int dims) {
            super(0L, 0L, 0L);
            this.dims = dims;
            int histoSize = 1 + (1 << dims);
            this.histoSubs = new int[Math.min(histoSize, 1025)];
        }

        public void histo(int pos) {
            if (pos < this.histoSubs.length) {
                int n = pos;
                this.histoSubs[n] = this.histoSubs[n] + 1;
            } else {
                int n = this.histoSubs.length - 1;
                this.histoSubs[n] = this.histoSubs[n] + 1;
            }
        }

        @Override
        public String toString() {
            return super.toString() + ";\nhistoVal:" + Arrays.toString(this.histoValues) + "\nhistoSub:" + Arrays.toString(this.histoSubs);
        }
    }
}

