/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TestDraw
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int LEN_X = 1000;
    private static final int LEN_Y = 1000;
    private static final int OFS_X = 50;
    private static final int OFS_Y = 50;
    private int[] data;
    private final MODE mode;

    private TestDraw(MODE mode) {
        this.mode = mode;
    }

    private void setData(double[] data, int DIM, int dx, int dy) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < data.length; i += DIM) {
            double x = data[i + dx];
            double y = data[i + dy];
            minX = this.min(x, minX);
            minY = this.min(y, minY);
            maxX = this.max(x, maxX);
            maxY = this.max(y, maxY);
        }
        System.out.println("TestDraw min/max: " + minX + "/" + maxX + "    " + minY + "/" + maxY);
        minY = minX = this.min(minX, minY);
        maxY = maxX = this.max(maxX, maxY);
        this.data = new int[data.length / DIM * 2];
        int i2 = 0;
        double xNorm = 1000.0 / (maxX - minX);
        double yNorm = 1000.0 / (maxY - minY);
        for (int i = 0; i < data.length; i += DIM) {
            double x = data[i + dx];
            double y = data[i + dy];
            int x2 = (int)((x - minX) * xNorm);
            int y2 = (int)((y - minY) * yNorm);
            this.data[i2++] = x2;
            this.data[i2++] = y2;
        }
    }

    private void setData(long[] data, int DIM, int dx, int dy) {
        long minX = Long.MAX_VALUE;
        long minY = Long.MAX_VALUE;
        long maxX = -9223372036854775807L;
        long maxY = -9223372036854775807L;
        int n = 0;
        for (int i = 0; i < data.length; i += DIM) {
            ++n;
            long x = data[i + dx];
            long y = data[i + dy];
            minX = this.min(x, minX);
            minY = this.min(y, minY);
            maxX = this.max(x, maxX);
            maxY = this.max(y, maxY);
        }
        System.out.println("TestDraw min/max: " + minX + "/" + maxX + "    " + minY + "/" + maxY);
        minY = minX = this.min(minX, minY);
        maxY = maxX = this.max(maxX, maxY);
        this.data = new int[2 * n];
        int i2 = 0;
        for (int i = 0; i < data.length; i += DIM) {
            long x = data[i + dx];
            long y = data[i + dy];
            int x2 = (int)((x - minX) * 1000L / (maxX - minX));
            int y2 = (int)((y - minY) * 1000L / (maxY - minY));
            this.data[i2++] = x2;
            this.data[i2++] = y2;
        }
    }

    private long min(long x, long minX) {
        return x < minX ? x : minX;
    }

    private long max(long x, long maxX) {
        return x > maxX ? x : maxX;
    }

    private double min(double x, double minX) {
        return x < minX ? x : minX;
    }

    private double max(double x, double maxX) {
        return x > maxX ? x : maxX;
    }

    @Override
    public void paintComponent(Graphics g) {
        int MAX = (int)this.min(10000000L, this.data.length);
        int n = 0;
        if (this.mode == MODE.POINTS) {
            int i = 0;
            while (i < MAX) {
                int x = this.data[i++];
                int y = this.data[i++];
                g.drawOval(x, 1000 - y, 0, 0);
                ++n;
            }
            System.out.println("Points drawn: " + n);
        } else if (this.mode == MODE.LINES) {
            int i = 0;
            while (i < MAX) {
                int x1 = this.data[i++];
                int y1 = this.data[i++];
                int x2 = this.data[i++];
                int y2 = this.data[i++];
                g.drawLine(x1, 1000 - y1, x2, 1000 - y2);
                ++n;
            }
            System.out.println("Lines drawn: " + n);
        } else {
            int i = 0;
            while (i < MAX) {
                int x1 = this.data[i++];
                int y1 = this.data[i++];
                int x2 = this.data[i++];
                int y2 = this.data[i++];
                g.drawRect(50 + x1, 50 + y1, x2 - x1, y2 - y1);
                ++n;
            }
            System.out.println("Rectangles drawn: " + n);
        }
    }

    public static void draw(double[][] data) {
        int dim = data[0].length;
        double[] data2 = new double[data.length * dim];
        int i = 0;
        for (double[] d : data) {
            System.arraycopy(d, 0, data2, i, d.length);
            i += dim;
        }
        TestDraw.draw(data2, dim);
    }

    public static void draw(double[] data, int dim) {
        TestDraw.draw(data, dim, MODE.POINTS);
    }

    public static void draw(double[] data, int dim, MODE mode) {
        JFrame frame = new JFrame("MyPanel");
        frame.setDefaultCloseOperation(3);
        frame.setBounds(30, 30, 1100, 1100);
        TestDraw panel = new TestDraw(mode);
        panel.setData(data, dim, 0, 1);
        frame.setContentPane(panel);
        frame.setVisible(true);
    }

    public static void draw(double[][] data, int dim, MODE mode) {
        double[] data2 = new double[data.length * data[0].length];
        int i = 0;
        double[][] dArray = data;
        int n = dArray.length;
        for (int j = 0; j < n; ++j) {
            double[] da;
            for (double d : da = dArray[j]) {
                data2[i++] = d;
            }
        }
        TestDraw.draw(data2, dim, mode);
    }

    public static void draw(long[] data, int dim, int dx, int dy) {
        JFrame frame = new JFrame("MyPanel");
        frame.setDefaultCloseOperation(3);
        frame.setBounds(30, 30, 1100, 1100);
        TestDraw panel = new TestDraw(MODE.POINTS);
        panel.setData(data, dim, dx, dy);
        frame.setContentPane(panel);
        frame.setVisible(true);
    }

    public static void draw(long[][] data, int dim, int dx, int dy) {
        long[] d = new long[2 * data.length];
        int i = 0;
        for (long[] l : data) {
            d[i++] = l[dx];
            d[i++] = l[dy];
        }
        TestDraw.draw(d, 2, 0, 1);
    }

    public static enum MODE {
        POINTS,
        LINES,
        RECTANGLES;

    }
}

