/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.tinspin.index.util.MinMaxHeapI;
import org.tinspin.index.util.StringBuilderLn;

public class MinMaxHeap<T>
implements MinMaxHeapI<T> {
    private static final int DEFAULT_SIZE = 16;
    private T[] data;
    private int size = 0;
    private final Less<T> less;

    private MinMaxHeap(int capacity, Less<T> lessFn) {
        this.data = new Object[capacity];
        this.less = lessFn;
    }

    public static <T extends Comparable<T>> MinMaxHeap<T> create() {
        return new MinMaxHeap(16, new LessWrapper(Comparable::compareTo));
    }

    public static <T> MinMaxHeap<T> createWithComparator(Comparator<T> compareFn) {
        return new MinMaxHeap<T>(16, new LessWrapper<T>(compareFn));
    }

    public static <T> MinMaxHeap<T> create(Less<T> less) {
        return new MinMaxHeap<T>(16, less);
    }

    private static boolean isMinLevel(int index) {
        return (Integer.numberOfLeadingZeros(index) & 1) != 0;
    }

    private boolean hasChildren(int i) {
        return i * 2 <= this.size;
    }

    private boolean isGrandchildOf(int m, int i) {
        return m >> 2 == i;
    }

    private void swap(int i1, int i2) {
        T v = this.data[i1];
        this.data[i1] = this.data[i2];
        this.data[i2] = v;
    }

    private int parent(int i) {
        return i >> 1;
    }

    private boolean hasGrandparent(int i) {
        return i >> 2 > 0;
    }

    private int grandparent(int i) {
        return i >> 2;
    }

    private int indexOfSmallestChildOrGrandchild(int index) {
        int min34;
        int min12;
        int end = this.end();
        int start = index * 4;
        int firstChild = index * 2;
        if (start >= end) {
            if (firstChild + 1 < end) {
                return this.less.less(this.data[firstChild], this.data[firstChild + 1]) ? firstChild : firstChild + 1;
            }
            return firstChild;
        }
        if (start + 1 < end) {
            min12 = start + (this.less.less(this.data[start], this.data[start + 1]) ? 0 : 1);
            min34 = (start += 2) + 1 < end ? (this.less.less(this.data[start], this.data[start + 1]) ? start : start + 1) : (start < end ? start : index * 2 + 1);
        } else {
            min12 = start;
            min34 = (start += 2) < end ? start : index * 2 + 1;
        }
        return this.less.less(this.data[min12], this.data[min34]) ? min12 : min34;
    }

    private int indexOfLargestChildOrGrandchild(int index) {
        int max34;
        int max12;
        int end = this.end();
        int start = index * 4;
        int firstChild = index * 2;
        if (start >= end) {
            if (firstChild + 1 < end) {
                return this.less.less(this.data[firstChild], this.data[firstChild + 1]) ? firstChild + 1 : firstChild;
            }
            return firstChild;
        }
        if (start + 1 < end) {
            max12 = start + (this.less.less(this.data[start], this.data[start + 1]) ? 1 : 0);
            max34 = (start += 2) + 1 < end ? (this.less.less(this.data[start], this.data[start + 1]) ? start + 1 : start) : (start < end ? start : index * 2 + 1);
        } else {
            max12 = start;
            max34 = (start += 2) < end ? start : index * 2 + 1;
        }
        return this.less.less(this.data[max12], this.data[max34]) ? max34 : max12;
    }

    private void pushDown(int m) {
        while (this.hasChildren(m)) {
            int i = m;
            if (MinMaxHeap.isMinLevel(i)) {
                m = this.indexOfSmallestChildOrGrandchild(i);
                if (this.less.less(this.data[m], this.data[i])) {
                    this.swap(m, i);
                    if (this.isGrandchildOf(m, i)) {
                        if (this.less.less(this.data[m], this.data[this.parent(m)])) continue;
                        this.swap(m, this.parent(m));
                        continue;
                    }
                    return;
                }
                return;
            }
            m = this.indexOfLargestChildOrGrandchild(i);
            if (!this.less.less(this.data[m], this.data[i])) {
                this.swap(m, i);
                if (this.isGrandchildOf(m, i)) {
                    if (!this.less.less(this.data[m], this.data[this.parent(m)])) continue;
                    this.swap(m, this.parent(m));
                    continue;
                }
                return;
            }
            return;
        }
    }

    private void pushUp(int index, T value) {
        if (MinMaxHeap.isMinLevel(index)) {
            if (!this.less.less(value, this.data[this.parent(index)])) {
                this.data[index] = this.data[this.parent(index)];
                this.pushUpMax(this.parent(index), value);
            } else {
                this.pushUpMin(index, value);
            }
        } else if (this.less.less(value, this.data[this.parent(index)])) {
            this.data[index] = this.data[this.parent(index)];
            this.pushUpMin(this.parent(index), value);
        } else {
            this.pushUpMax(index, value);
        }
    }

    private void pushUpMin(int index, T value) {
        while (this.hasGrandparent(index) && this.less.less(value, this.data[this.grandparent(index)])) {
            this.data[index] = this.data[this.grandparent(index)];
            index = this.grandparent(index);
        }
        this.data[index] = value;
    }

    private void pushUpMax(int index, T value) {
        while (this.hasGrandparent(index) && !this.less.less(value, this.data[this.grandparent(index)])) {
            this.data[index] = this.data[this.grandparent(index)];
            index = this.grandparent(index);
        }
        this.data[index] = value;
    }

    private int end() {
        return this.size + 1;
    }

    @Override
    public void push(T value) {
        if (this.size == 0) {
            this.data[1] = value;
            ++this.size;
            return;
        }
        if (this.size + 1 >= this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        ++this.size;
        this.pushUp(this.size, value);
    }

    @Override
    public void popMin() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int end = this.end();
        T value = this.data[end - 1];
        this.data[end - 1] = null;
        --this.size;
        if (this.size == 0) {
            return;
        }
        this.data[1] = value;
        this.pushDown(1);
    }

    @Override
    public void popMax() {
        int max;
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        if (this.size == 1) {
            --this.size;
            this.data[1] = null;
            return;
        }
        if (this.size == 2) {
            --this.size;
            this.data[2] = null;
            return;
        }
        int n = max = this.less.less(this.data[2], this.data[3]) ? 3 : 2;
        if (this.size == 3) {
            --this.size;
            if (max == 2) {
                this.data[2] = this.data[3];
            }
            this.data[3] = null;
            return;
        }
        int end = this.end();
        T value = this.data[end - 1];
        this.data[end - 1] = null;
        --this.size;
        this.data[max] = value;
        this.pushDown(max);
    }

    @Override
    public T peekMin() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        return this.data[1];
    }

    @Override
    public T peekMax() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        if (this.size == 1) {
            return this.data[1];
        }
        if (this.size == 2) {
            return this.data[2];
        }
        return this.less.less(this.data[2], this.data[3]) ? this.data[3] : this.data[2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public String print() {
        StringBuilderLn s = new StringBuilderLn();
        int x = 2;
        for (int i = 1; i <= this.size; ++i) {
            if (i % x == 0) {
                s.appendLn();
                x *= 2;
            }
            s.append(this.data[i] + "   ");
        }
        s.appendLn();
        return s.toString();
    }

    @Override
    public void clear() {
        this.size = 0;
        if (this.data.length > 16) {
            this.data = new Object[16];
        } else {
            Arrays.fill(this.data, null);
        }
    }

    static class LessWrapper<C>
    implements Less<C> {
        private final Comparator<C> comp;

        LessWrapper(Comparator<C> comp) {
            this.comp = comp;
        }

        @Override
        public boolean less(C o1, C o2) {
            return this.comp.compare(o1, o2) < 0;
        }
    }

    @FunctionalInterface
    public static interface Less<T> {
        public boolean less(T var1, T var2);
    }
}

