/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.covertree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.covertree.CoverTree;
import org.tinspin.index.covertree.Node;

public class CoverTreeQueryKnn<T>
implements Index.PointIteratorKnn<T> {
    private final CoverTree<T> tree;
    private double[] center;
    private Iterator<Index.PointEntryKnn<T>> iter;
    private PointDistance dist;
    private final ArrayList<Index.PointEntryKnn<T>> candidates = new ArrayList();
    private final ArrayList<Index.PointEntryKnn<Object>> pool = new ArrayList();
    private final PriorityQueue<Index.PointEntryKnn<Object>> queue = new PriorityQueue(new Index.PEComparator());

    public CoverTreeQueryKnn(CoverTree<T> tree, double[] center, int k, PointDistance dist) {
        this.tree = tree;
        this.reset(center, k, dist == null ? PointDistance.L2 : dist);
    }

    @Override
    public CoverTreeQueryKnn<T> reset(double[] center, int k) {
        this.reset(center, k, null);
        return this;
    }

    public void reset(double[] center, int k, PointDistance dist) {
        if (dist != null) {
            this.dist = dist;
        }
        if (this.dist != PointDistance.L2) {
            System.err.println("This distance iterator only works for L2 distance");
        }
        this.center = center;
        this.pool.addAll(this.queue);
        this.queue.clear();
        this.candidates.clear();
        this.candidates.ensureCapacity(k);
        if (k <= 0 || this.tree.size() == 0) {
            this.iter = this.candidates.iterator();
            return;
        }
        this.search(k);
        this.iter = this.candidates.iterator();
    }

    private void search(int k) {
        this.addToQueue(this.tree.getRoot());
        while (!this.queue.isEmpty()) {
            Index.PointEntryKnn<Object> candidate = this.queue.poll();
            Object o = candidate.value();
            if (!(o instanceof Node)) {
                this.candidates.add(candidate);
                if (this.candidates.size() < k) continue;
                return;
            }
            ArrayList entries = ((Node)o).getChildren();
            if (entries != null) {
                for (int i = 0; i < entries.size(); ++i) {
                    this.addToQueue(entries.get(i));
                }
            }
            this.pool.add(candidate);
        }
    }

    private void addToQueue(Node<T> node) {
        double dRootPoint = this.dist.dist(this.center, node.point());
        double maxDist = node.maxdist(this.tree);
        double dRootNode = maxDist > dRootPoint ? 0.0 : dRootPoint - maxDist;
        this.queue.add(this.createEntry(node.point().point(), node, dRootNode));
        this.queue.add(this.createEntry(node.point().point(), node.point(), dRootPoint));
    }

    private Index.PointEntryKnn<Object> createEntry(double[] data, Object val, double dist) {
        if (this.pool.isEmpty()) {
            return new Index.PointEntryKnn<Object>(data, val, dist);
        }
        Index.PointEntryKnn<Object> e = this.pool.remove(this.pool.size() - 1);
        e.set(data, val, dist);
        return e;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Index.PointEntryKnn<T> next() {
        return this.iter.next();
    }
}

