/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.covertree;

import java.util.ArrayList;
import org.tinspin.index.Index;
import org.tinspin.index.covertree.CoverTree;

public class Node<T> {
    private Index.PointEntry<T> p;
    private ArrayList<Node<T>> children;
    private int level;
    private double distToParent;
    private double maxDist = -1.0;

    Node(Index.PointEntry<T> p, int level) {
        this.p = p;
        this.level = level;
    }

    Node<T> initLevel(int level) {
        this.level = level;
        this.maxDist = 0.0;
        return this;
    }

    Index.PointEntry<T> point() {
        return this.p;
    }

    void setDistanceToParent(double d) {
        this.distToParent = d;
    }

    double getDistanceToParent() {
        return this.distToParent;
    }

    void addChild(Node<T> node, double distToParent) {
        if (node.level + 1 != this.level) {
            throw new IllegalStateException("level" + this.level + "/" + node.level);
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        node.distToParent = distToParent;
        if (node.hasChildren()) {
            if (node.maxDist == -1.0 || node.distToParent + node.maxDist > this.maxDist) {
                this.maxDist = -1.0;
            }
        } else if (this.maxDist != -1.0 && distToParent > this.maxDist) {
            this.maxDist = distToParent;
        }
        this.children.add(node);
    }

    void replaceChild(int i, Node<T> qNew) {
        this.children.set(i, qNew);
    }

    ArrayList<Node<T>> getChildren() {
        return this.children;
    }

    ArrayList<Node<T>> getOrCreateChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    Node<T> removeAnyLeaf() {
        Node<T> any = this.children.get(0);
        if (any.hasChildren()) {
            this.maxDist = -1.0;
            return any.removeAnyLeaf();
        }
        Node<T> leaf = this.children.remove(0);
        if (this.children.isEmpty()) {
            this.maxDist = 0.0;
        } else if (leaf.getDistanceToParent() >= this.maxDist) {
            this.maxDist = -1.0;
        }
        return leaf;
    }

    double maxdist(CoverTree<T> tree) {
        if (this.maxDist == -1.0) {
            this.maxDist = Node.recalcMaxDist(this, this, tree);
        }
        return this.maxDist;
    }

    double maxdistInternal() {
        return this.maxDist;
    }

    void adjustMaxDist(double newDist) {
        this.maxDist = this.maxDist == -1.0 ? -1.0 : Math.max(newDist, this.maxDist);
    }

    private static <T> double recalcMaxDist(Node<T> p, Node<T> node, CoverTree<T> tree) {
        double maxDist = 0.0;
        if (node.children != null) {
            for (int i = 0; i < node.children.size(); ++i) {
                Node<T> child = node.children.get(i);
                double distChild = p == node ? child.getDistanceToParent() : tree.d(p, child);
                maxDist = Math.max(maxDist, distChild);
                double maxDistChild = child.maxdist(tree);
                if (!(maxDistChild + distChild > maxDist)) continue;
                maxDist = Math.max(maxDist, Node.recalcMaxDist(p, child, tree));
            }
        }
        return maxDist;
    }

    int getLevel() {
        return this.level;
    }

    void setLevel(int level) {
        this.level = level;
    }

    void invalidateMaxDist() {
        this.maxDist = -1.0;
    }

    void removeChild(int i) {
        Node<T> n = this.children.remove(i);
        if (this.maxDist != -1.0) {
            if (n.maxDist != -1.0 && n.getDistanceToParent() + n.maxDist >= this.maxDist) {
                this.maxDist = -1.0;
            } else if (n.maxDist == -1.0) {
                this.maxDist = -1.0;
            }
        }
    }

    void clearAndRemoveAllChildren(ArrayList<Node<T>> clearedChildren) {
        if (this.hasChildren()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Node<T> c = this.children.get(i);
                c.clearAndRemoveAllChildren(clearedChildren);
            }
            clearedChildren.addAll(this.children);
            this.children.clear();
        }
        this.maxDist = 0.0;
        this.distToParent = 0.0;
    }
}

