/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.phtree;

import ch.ethz.globis.phtree.PhEntryDistF;
import ch.ethz.globis.phtree.PhEntryF;
import ch.ethz.globis.phtree.PhTreeMultiMapF2;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.PointMultimap;
import org.tinspin.index.Stats;
import org.tinspin.index.phtree.PHStats;

public class PHTreeMMP<T>
implements PointMultimap<T> {
    private final PhTreeMultiMapF2<T> tree;

    private PHTreeMMP(int dims) {
        this.tree = PhTreeMultiMapF2.create((int)dims);
    }

    public static <T> PHTreeMMP<T> create(int dims) {
        return new PHTreeMMP<T>(dims);
    }

    @Override
    public int getDims() {
        return this.tree.getDim();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public Stats getStats() {
        return new PHStats(this.tree.getStats(), this.tree.getDim());
    }

    @Override
    public int getNodeCount() {
        return this.tree.getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.tree.getStats().getBitDepth();
    }

    @Override
    public String toStringTree() {
        return this.tree.toStringTree();
    }

    @Override
    public void insert(double[] key, T value) {
        this.tree.put(key, value);
    }

    @Override
    public boolean remove(double[] key, T value) {
        return this.tree.remove(key, value);
    }

    @Override
    public boolean removeIf(double[] point, Predicate<Index.PointEntry<T>> condition) {
        for (Object t : this.tree.get(point)) {
            if (!condition.test(new Index.PointEntry(point, t))) continue;
            return this.tree.remove(point, t);
        }
        return false;
    }

    @Override
    public boolean update(double[] oldPoint, double[] newPoint, T value) {
        return this.tree.update(oldPoint, value, newPoint);
    }

    @Override
    public boolean contains(double[] point, T value) {
        for (Object t : this.tree.get(point)) {
            if (!Objects.equals(value, t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Index.PointIterator<T> queryExactPoint(double[] key) {
        return new IteratorPlain(key);
    }

    @Override
    public Index.PointIterator<T> query(double[] min, double[] max) {
        return new IteratorWQ(this.tree.query(min, max));
    }

    @Override
    public Index.PointIterator<T> iterator() {
        return new ExtentWrapper();
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k) {
        return new IteratorKnn(this.tree.nearestNeighbour(k, center));
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k, PointDistance distFn) {
        throw new UnsupportedOperationException();
    }

    private static class IteratorKnn<T>
    implements Index.PointIteratorKnn<T> {
        private final PhTreeMultiMapF2.PhKnnQueryF<T> iter;

        private IteratorKnn(PhTreeMultiMapF2.PhKnnQueryF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.PointEntryKnn<T> next() {
            PhEntryDistF e = this.iter.nextEntryReuse();
            return new Index.PointEntryKnn<Object>((double[])e.getKey().clone(), e.getValue(), e.dist());
        }

        @Override
        public IteratorKnn<T> reset(double[] center, int k) {
            this.iter.reset(k, null, center);
            return this;
        }
    }

    private class IteratorPlain
    implements Index.PointIterator<T> {
        private Iterator<T> iter;
        private double[] key;

        private IteratorPlain(double[] key) {
            this.reset(key, null);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.PointEntry<T> next() {
            return new Index.PointEntry(this.key, this.iter.next());
        }

        @Override
        public Index.PointIterator<T> reset(double[] point, double[] mustBeNull) {
            if (mustBeNull != null) {
                throw new UnsupportedOperationException("second argument must be `null`");
            }
            this.iter = PHTreeMMP.this.tree.get(point).iterator();
            this.key = point;
            return this;
        }
    }

    private static class IteratorWQ<T>
    implements Index.PointIterator<T> {
        private final PhTreeMultiMapF2.PhQueryF<T> iter;

        private IteratorWQ(PhTreeMultiMapF2.PhQueryF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.PointEntry<T> next() {
            PhEntryF e = this.iter.nextEntryReuse();
            return new Index.PointEntry<Object>((double[])e.getKey().clone(), e.getValue());
        }

        @Override
        public Index.PointIterator<T> reset(double[] min, double[] max) {
            this.iter.reset(min, max);
            return this;
        }
    }

    private class ExtentWrapper
    implements Index.PointIterator<T> {
        private PhTreeMultiMapF2.PhIteratorF<T> iter;

        private ExtentWrapper() {
            this.reset(null, null);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.PointEntry<T> next() {
            PhEntryF e = this.iter.nextEntryReuse();
            return new Index.PointEntry<Object>((double[])e.getKey().clone(), e.getValue());
        }

        @Override
        public Index.PointIterator<T> reset(double[] min, double[] max) {
            if (min != null || max != null) {
                throw new UnsupportedOperationException("min/max must be `null`");
            }
            this.iter = PHTreeMMP.this.tree.queryExtent();
            return this;
        }
    }
}

