/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.Index;
import org.tinspin.index.rtree.Filter;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeEntry;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;
import org.tinspin.index.rtree.RTreeNodeLeaf;

class RTreeMixedQuery2<T>
implements Iterator<Index.BoxEntryKnn<T>> {
    private final RTree<T> tree;
    private final double[] center;
    private final BoxDistance dist;
    private final BoxDistance closestDist;
    private final PriorityQueue<RTreeNodeWrapper<T>> queue = new PriorityQueue();
    private final Filter filter;
    private RTreeNodeWrapper<T> next;
    private RTreeNodeWrapper<T> current;
    private double distanceOfLastReturnedNode = Double.NEGATIVE_INFINITY;
    private List<RTreeNodeWrapper<T>> nodesAlreadyReturnedWithSameDist = new ArrayList<RTreeNodeWrapper<T>>();
    private int remove_pointerLoss;
    private int remove_hit;

    public RTreeMixedQuery2(RTree<T> tree, double[] center, Filter filter, BoxDistance dist, BoxDistance closestDist) {
        this.tree = tree;
        this.center = center;
        this.closestDist = closestDist;
        this.filter = filter;
        this.dist = dist;
        this.init();
    }

    private void init() {
        this.insert(this.tree.getRoot());
    }

    private void insert(RTreeNode<T> node) {
        if (this.filter.intersects(node.min(), node.max())) {
            RTreeNodeWrapper<T> wrapped = new RTreeNodeWrapper<T>(node, this.closestDist.dist(this.center, node.min(), node.max()));
            this.queue.add(wrapped);
        }
    }

    private RTreeNodeWrapper<T> findNext() {
        RTreeNodeWrapper<T> nextElement = null;
        while (nextElement == null && !this.queue.isEmpty()) {
            RTreeNodeWrapper<T> top = this.queue.poll();
            RTreeEntry ent = top.node;
            if (ent instanceof RTreeNodeDir) {
                this.processNode((RTreeNodeDir)ent);
            } else if (ent instanceof RTreeNodeLeaf) {
                this.processNode((RTreeNodeLeaf)ent);
            } else {
                nextElement = top;
            }
            if (nextElement == null) continue;
            if (nextElement.dist() > this.distanceOfLastReturnedNode) {
                this.distanceOfLastReturnedNode = nextElement.dist();
                this.nodesAlreadyReturnedWithSameDist.clear();
                continue;
            }
            if (nextElement.dist() < this.distanceOfLastReturnedNode) {
                nextElement = null;
                continue;
            }
            if (!this.nodesAlreadyReturnedWithSameDist.contains(nextElement)) continue;
            nextElement = null;
        }
        if (nextElement != null) {
            this.nodesAlreadyReturnedWithSameDist.add(nextElement);
        }
        return nextElement;
    }

    private void processNode(RTreeNodeDir<T> node) {
        ArrayList<RTreeNode<T>> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            this.insert(children.get(i));
        }
    }

    private void processNode(RTreeNodeLeaf<T> node) {
        ArrayList<RTreeEntry<T>> entries = node.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            this.insert(entries.get(i));
        }
    }

    private void insert(RTreeEntry<T> ent) {
        if (!this.filter.matches(ent)) {
            return;
        }
        double distance = this.dist.dist(this.center, ent.min(), ent.max());
        if (distance < this.distanceOfLastReturnedNode) {
            return;
        }
        RTreeNodeWrapper<T> wrapped = new RTreeNodeWrapper<T>(ent, distance);
        if (distance == this.distanceOfLastReturnedNode && this.nodesAlreadyReturnedWithSameDist.contains(wrapped)) {
            return;
        }
        this.queue.add(wrapped);
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.findNext();
        }
        return this.next != null;
    }

    @Override
    public Index.BoxEntryKnn<T> next() {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        this.current = this.next;
        this.next = null;
        return this.current;
    }

    public String toString() {
        return "RTreeMixedQuery [queueSize=" + this.queueSize() + ", rm.loss=" + this.remove_pointerLoss + ", rm.hit=" + this.remove_hit + ", center=" + Arrays.toString(this.center) + ", dist=" + this.dist + "]";
    }

    int queueSize() {
        return this.queue.size();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class RTreeNodeWrapper<T>
    extends Index.BoxEntryKnn<T>
    implements Comparable<RTreeNodeWrapper<T>> {
        RTreeEntry<T> node;

        RTreeNodeWrapper(RTreeEntry<T> node, double distance) {
            super(node.min(), node.max(), node.value(), distance);
            this.node = node;
        }

        public String toString() {
            return "RTreeNodeWrapper [lower()=" + Arrays.toString(this.min()) + ", upper()=" + Arrays.toString(this.max()) + ", value()=" + this.value() + ", dist()=" + this.dist() + "]";
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RTreeNodeWrapper other = (RTreeNodeWrapper)obj;
            return !(this.node == null ? other.node != null : !this.node.equals(other.node));
        }

        @Override
        public int compareTo(RTreeNodeWrapper<T> o) {
            return Double.compare(this.dist(), o.dist());
        }
    }
}

