/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.Index;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeEntry;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;

public class RTreeQuery1nn<T> {
    private static final DEComparator COMP = new DEComparator();
    private final RTree<T> tree;
    private double[] center;
    private IteratorStack stack;
    private BoxDistance dist;

    public RTreeQuery1nn(RTree<T> tree) {
        this.stack = new IteratorStack(tree.getDepth(), 10);
        this.tree = tree;
    }

    public Index.BoxEntryKnn<T> reset(double[] center, BoxDistance dist) {
        if (this.stack.stack.length < this.tree.getDepth()) {
            this.stack = new IteratorStack(this.tree.getDepth(), 10);
        } else {
            this.stack.size = 0;
        }
        if (dist != null) {
            this.dist = dist;
        }
        if (this.dist == null) {
            this.dist = BoxDistance.EDGE;
        }
        if (this.dist != BoxDistance.EDGE) {
            System.err.println("This distance iterator only works for EDGE distance");
        }
        this.center = center;
        if (this.tree.size() == 0) {
            return null;
        }
        this.stack.prepareAndPush(this.tree.getRoot(), Double.POSITIVE_INFINITY);
        return this.findCandidate();
    }

    private Index.BoxEntryKnn<T> findCandidate() {
        Index.BoxEntryKnn<Object> candidate = new Index.BoxEntryKnn<Object>(null, null, null, Double.POSITIVE_INFINITY);
        double currentDist = Double.MAX_VALUE;
        while (!this.stack.isEmpty()) {
            IterPos ip = this.stack.peek();
            if (ip.node instanceof RTreeNodeDir) {
                if (ip.pos < ip.maxPos && ip.subNodes[ip.pos].dist < currentDist) {
                    this.stack.prepareAndPush(ip.subNodes[ip.pos].node, currentDist);
                    ++ip.pos;
                    continue;
                }
            } else {
                ArrayList entries = ip.node.getEntries();
                while (ip.pos < entries.size()) {
                    RTreeEntry e = entries.get(ip.pos);
                    ++ip.pos;
                    double d = this.dist(this.center, e.min(), e.max());
                    if (!(candidate.dist() > d)) continue;
                    candidate.set(e.min(), e.max(), e.value(), d);
                    currentDist = d;
                }
            }
            this.stack.pop();
        }
        return candidate;
    }

    protected void sortEntries(IterPos<T> iPos, double minDist) {
        int i;
        ArrayList subNodes = ((RTreeNodeDir)iPos.node).getChildren();
        NodeDistT<T>[] ret = iPos.subNodes;
        int pos = 0;
        for (i = 0; i < subNodes.size(); ++i) {
            RTreeNode e = subNodes.get(i);
            double d = this.dist(this.center, e.min(), e.max());
            if (!(d < minDist)) continue;
            ret[pos++].set(e, d);
        }
        Arrays.sort(ret, 0, pos, COMP);
        for (i = 0; i < pos; ++i) {
            if (!(ret[i].dist > minDist)) continue;
            pos = i;
            break;
        }
        iPos.maxPos = pos;
    }

    private double dist(double[] center, double[] min, double[] max) {
        this.tree.incNDist1NN();
        return this.dist.dist(center, min, max);
    }

    private static class NodeDistT<T> {
        double dist;
        RTreeNode<T> node;

        public NodeDistT(double dist, RTreeNode<T> node) {
            this.dist = dist;
            this.node = node;
        }

        public void set(RTreeNode<T> node, double dist) {
            this.node = node;
            this.dist = dist;
        }
    }

    private static class IterPos<T> {
        final NodeDistT<T>[] subNodes;
        RTreeNode<T> node;
        int pos;
        int maxPos;

        public IterPos(int nSubNodes) {
            this.subNodes = new NodeDistT[nSubNodes];
            for (int i = 0; i < nSubNodes; ++i) {
                this.subNodes[i] = new NodeDistT(Double.POSITIVE_INFINITY, null);
            }
        }

        void init(RTreeNode<T> node) {
            this.node = node;
            this.pos = 0;
        }
    }

    private static class DEComparator
    implements Comparator<NodeDistT<?>> {
        private DEComparator() {
        }

        @Override
        public int compare(NodeDistT o1, NodeDistT o2) {
            return Double.compare(o1.dist, o2.dist);
        }
    }

    private class IteratorStack {
        private final IterPos<T>[] stack;
        private int size = 0;

        IteratorStack(int depth, int nSubNodes) {
            this.stack = new IterPos[depth];
            for (int i = 0; i < this.stack.length; ++i) {
                this.stack[i] = new IterPos(nSubNodes);
            }
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        void prepareAndPush(RTreeNode<T> node, double minDist) {
            IterPos ni = this.stack[this.size++];
            ni.init(node);
            if (ni.node instanceof RTreeNodeDir) {
                RTreeQuery1nn.this.sortEntries(ni, minDist);
            }
        }

        IterPos<T> peek() {
            return this.stack[this.size - 1];
        }

        void pop() {
            --this.size;
        }
    }
}

