/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.tinspin.index.Index;
import org.tinspin.index.qthypercube.QNode;
import org.tinspin.index.qthypercube.QUtil;
import org.tinspin.index.qthypercube.QuadTreeKD;

public class QIterator0<T>
implements Index.PointIterator<T> {
    private final QuadTreeKD<T> tree;
    private final IteratorStack stack = new IteratorStack();
    private Index.PointEntry<T> next = null;
    private double[] min;
    private double[] max;

    QIterator0(QuadTreeKD<T> tree, double[] min, double[] max) {
        this.tree = tree;
        this.reset(min, max);
    }

    private void findNext() {
        while (!this.stack.isEmpty()) {
            StackEntry se = this.stack.peek();
            while (se.pos < se.len) {
                int pos;
                ++se.pos;
                if (se.isLeaf()) {
                    Index.PointEntry e = se.vals.get(pos);
                    if (!QUtil.isPointEnclosed(e.point(), this.min, this.max)) continue;
                    this.next = e;
                    return;
                }
                QNode node = se.subs[pos];
                if (node == null || !QUtil.overlap(this.min, this.max, node.getCenter(), node.getRadius())) continue;
                se = this.stack.prepareAndPush(node);
            }
            this.stack.pop();
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Index.PointEntry<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Index.PointEntry<T> ret = this.next;
        this.findNext();
        return ret;
    }

    @Override
    public Index.PointIterator<T> reset(double[] min, double[] max) {
        this.stack.clear();
        this.min = min;
        this.max = max;
        this.next = null;
        if (this.tree.getRoot() != null) {
            this.stack.prepareAndPush(this.tree.getRoot());
            this.findNext();
        }
        return this;
    }

    private static class StackEntry<T> {
        int pos;
        QNode<T>[] subs;
        ArrayList<Index.PointEntry<T>> vals;
        int len;

        private StackEntry() {
        }

        void set(QNode<T> node) {
            this.pos = 0;
            this.vals = node.getEntries();
            this.subs = node.getChildNodes();
            this.len = this.vals != null ? this.vals.size() : this.subs.length;
        }

        public boolean isLeaf() {
            return this.vals != null;
        }
    }

    private class IteratorStack {
        private final ArrayList<StackEntry<T>> stack = new ArrayList();
        private int size = 0;

        IteratorStack() {
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        StackEntry<T> prepareAndPush(QNode<T> node) {
            if (this.size == this.stack.size()) {
                this.stack.add(new StackEntry());
            }
            StackEntry ni = this.stack.get(this.size++);
            ni.set(node);
            return ni;
        }

        StackEntry<T> peek() {
            return this.stack.get(this.size - 1);
        }

        void pop() {
            --this.size;
        }

        public void clear() {
            this.size = 0;
        }
    }
}

