/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.tinspin.index.Index;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeEntry;
import org.tinspin.index.rtree.RTreeNode;

public class RTreeIterator<T>
implements Index.BoxIterator<T> {
    private final RTree<T> tree;
    private double[] min;
    private double[] max;
    private IteratorStack stack;
    private boolean hasNext = true;
    private RTreeEntry<T> next;
    private final Predicate<RTreeEntry<T>> filter;

    public RTreeIterator(RTree<T> tree, double[] min, double[] max) {
        this.stack = new IteratorStack(tree.getDepth());
        this.tree = tree;
        this.filter = entry -> RTreeEntry.checkOverlap(this.min, this.max, entry);
        this.reset(min, max);
    }

    public static <T> RTreeIterator<T> createExactMatch(RTree<T> tree, double[] min, double[] max) {
        return new RTreeIterator<T>(tree, min, max, e -> e instanceof RTreeNode ? RTreeEntry.checkOverlap(min, max, e) : Arrays.equals(min, e.min()) && Arrays.equals(max, e.max()));
    }

    private RTreeIterator(RTree<T> tree, double[] min, double[] max, Predicate<RTreeEntry<T>> filter) {
        this.stack = new IteratorStack(tree.getDepth());
        this.tree = tree;
        this.filter = filter;
        this.reset(min, max);
    }

    @Override
    public Index.BoxIterator<T> reset(double[] min, double[] max) {
        if (this.stack.stack.length < this.tree.getDepth()) {
            this.stack = new IteratorStack(this.tree.getDepth());
        } else {
            this.stack.size = 0;
        }
        this.min = min;
        this.max = max;
        this.hasNext = true;
        if (!RTreeEntry.checkOverlap(min, max, this.tree.getRoot())) {
            this.hasNext = false;
            return null;
        }
        this.stack.prepareAndPush(this.tree.getRoot());
        this.findNext();
        return this;
    }

    private void findNext() {
        block0: while (!this.stack.isEmpty()) {
            IterPos ip = this.stack.peek();
            ArrayList entries = ip.node.getEntries();
            while (ip.pos < entries.size()) {
                RTreeEntry e = entries.get(ip.pos);
                ++ip.pos;
                if (!this.filter.test(e)) continue;
                if (e instanceof RTreeNode) {
                    this.stack.prepareAndPush((RTreeNode)e);
                    continue block0;
                }
                this.next = e;
                return;
            }
            this.stack.pop();
        }
        this.hasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public RTreeEntry<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        RTreeEntry<T> ret = this.next;
        this.findNext();
        return ret;
    }

    private static class IterPos<T> {
        private RTreeNode<T> node;
        private int pos;

        private IterPos() {
        }

        public void init(RTreeNode<T> node) {
            this.node = node;
            this.pos = 0;
        }
    }

    private class IteratorStack {
        private final IterPos<T>[] stack;
        private int size = 0;

        IteratorStack(int depth) {
            this.stack = new IterPos[depth];
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        void prepareAndPush(RTreeNode<T> node) {
            IterPos ni;
            if ((ni = this.stack[this.size++]) == null) {
                ni = new IterPos();
                this.stack[this.size - 1] = ni;
            }
            ni.init(node);
        }

        IterPos<T> peek() {
            return this.stack[this.size - 1];
        }

        void pop() {
            --this.size;
        }
    }
}

