/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.covertree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.PointMap;
import org.tinspin.index.Stats;
import org.tinspin.index.covertree.Node;

public class CoverTree<T>
implements PointMap<T> {
    private final int dims;
    private int nEntries;
    private Node<T> root = null;
    private static final double DEFAULT_BASE = 2.0;
    private static final boolean NEAREST_ANCESTOR = true;
    private final double BASE;
    private final double LOG_BASE;
    private final PointDistance dist;
    private static final Index.PEComparator comparator = new Index.PEComparator();
    private long nDistCalc = 0L;
    private long nDist1NN = 0L;
    private long nDistKNN = 0L;

    private final double log13(double n) {
        return Math.log(n) / this.LOG_BASE;
    }

    private CoverTree(int nDims, double base, PointDistance dist) {
        this.dims = nDims;
        this.BASE = base;
        this.LOG_BASE = Math.log(this.BASE);
        this.dist = dist != null ? dist : PointDistance.L2;
    }

    public static <T> Index.PointEntry<T> create(double[] point, T value) {
        return new Index.PointEntry<T>(point, value);
    }

    public static <T> CoverTree<T> create(int nDims) {
        return new CoverTree<T>(nDims, 2.0, PointDistance.L2);
    }

    public static <T> CoverTree<T> create(int nDims, double base, PointDistance dist) {
        return new CoverTree<T>(nDims, base, dist);
    }

    public static <T> CoverTree<T> create(Index.PointEntry<T>[] data, double base, PointDistance distFn) {
        if (data == null || data.length == 0) {
            throw new IllegalStateException("Bulk load with empty data no possible.");
        }
        CoverTree<T> tree = new CoverTree<T>(data[0].point().length, base, distFn);
        if (data.length == 1) {
            tree.root = new Node<T>(data[0], 0);
            ++tree.nEntries;
            return tree;
        }
        Index.PointEntry<T> newRoot = data[0];
        Index.PointEntry<T> mostDistantPoint = data[1];
        double largestDistance = tree.d(newRoot, mostDistantPoint);
        for (int i = 2; i < data.length; ++i) {
            Index.PointEntry<T> x = data[i];
            double dist = tree.d(newRoot, x);
            if (!(dist > largestDistance)) continue;
            largestDistance = dist;
            mostDistantPoint = x;
        }
        int requiredLevel = (int)(tree.log13(largestDistance) + 1.0);
        tree.root = new Node<T>(data[0], requiredLevel);
        for (int i = 1; i < data.length; ++i) {
            Node<T> x = new Node<T>(data[i], -1);
            tree.insert(tree.root, x);
        }
        tree.nEntries = data.length;
        return tree;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.nEntries;
    }

    @Override
    public void clear() {
        this.nEntries = 0;
        this.root = null;
    }

    @Override
    public CTStats getStats() {
        CTStats stats = new CTStats(this);
        if (this.root != null) {
            this.getStats(this.root, stats);
        }
        return stats;
    }

    @Override
    public int getNodeCount() {
        return this.nEntries;
    }

    @Override
    public int getDepth() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getLevel() - this.getStats().minLevel;
    }

    @Override
    public String toStringTree() {
        if (this.root != null) {
            return this.toStringTree(new StringBuilder(), this.root).toString();
        }
        return "";
    }

    private StringBuilder toStringTree(StringBuilder sb, Node<T> node) {
        this.toStringNode(sb, node);
        sb.append("\n");
        if (node.hasChildren()) {
            for (Node<T> c : node.getChildren()) {
                this.toStringTree(sb, c);
            }
        }
        return sb;
    }

    private StringBuilder toStringNode(StringBuilder sb, Node<T> node) {
        for (int i = this.root.getLevel(); i > node.getLevel(); --i) {
            sb.append(".");
        }
        sb.append("L=").append(node.getLevel());
        sb.append(";MaxD=").append("/").append(node.maxdistInternal());
        sb.append(";ParD=").append(node.getDistanceToParent());
        sb.append(";CovD=").append(this.covdist(node));
        if (node.hasChildren()) {
            sb.append(";nC=").append(node.getChildren().size());
        } else {
            sb.append(";nC=0");
        }
        sb.append(";coord=").append(Arrays.toString(node.point().point()));
        return sb;
    }

    @Override
    public void insert(double[] key, T value) {
        Node<T> x = new Node<T>(new Index.PointEntry<T>(key, value), -1);
        if (this.root == null) {
            this.root = x.initLevel(0);
            ++this.nEntries;
            return;
        }
        if (!this.root.hasChildren()) {
            double dist = this.d(this.root, x);
            int level = (int)this.log13(dist);
            this.root.setLevel(level + 1);
            Node<T> q = x.initLevel(level);
            this.root.addChild(q, dist);
            ++this.nEntries;
            return;
        }
        this.insert(this.root, x);
        ++this.nEntries;
    }

    private void insert(Node<T> p, Node<T> x) {
        double distPX = this.d(p, x);
        if (distPX > this.covdist(p)) {
            while (distPX > (this.BASE - 1.0) * this.covdist(p)) {
                Node<T> q;
                Node<T> p0 = q = p.removeAnyLeaf();
                q.setLevel(p.getLevel() + 1);
                q.addChild(p, this.d(q, p));
                p = p0;
                distPX = this.d(p, x);
            }
            Node<T> newRoot = x.initLevel(p.getLevel() + 1);
            newRoot.addChild(p, distPX);
            this.root = newRoot;
            return;
        }
        this.insert2NA(p, x, distPX);
    }

    private Node<T> insert2(Node<T> p, Node<T> x, double distPX) {
        ArrayList<Node<T>> children = p.getOrCreateChildren();
        double covDistQ = children.isEmpty() ? 0.0 : this.covdist(children.get(0));
        for (int i = 0; i < children.size(); ++i) {
            Node<T> q = children.get(i);
            double distQX = this.d(q, x);
            if (!(distQX <= covDistQ)) continue;
            Node<T> qNew = this.insert2(q, x, distQX);
            if (qNew != q) {
                p.replaceChild(i, qNew);
            }
            p.adjustMaxDist(distPX);
            return p;
        }
        p.addChild(x.initLevel(p.getLevel() - 1), distPX);
        return p;
    }

    private Node<T> insert2NA(Node<T> p, Node<T> x, double distPX) {
        ArrayList<Node<T>> children = p.getOrCreateChildren();
        double covDistQ = this.covDist(p.getLevel() - 1);
        Node<T> best = null;
        double distBest = Double.MAX_VALUE;
        int posBest = -1;
        for (int i = 0; i < children.size(); ++i) {
            Node<T> q = children.get(i);
            double distQX = this.d(q, x);
            if (!(distQX <= covDistQ) || !(distQX < distBest)) continue;
            distBest = distQX;
            best = q;
            posBest = i;
        }
        if (best != null) {
            Node<T> q = best;
            double distQX = distBest;
            int i = posBest;
            Node<T> qNew = this.insert2NA(q, x, distQX);
            if (qNew != q) {
                p.replaceChild(i, qNew);
            }
            p.adjustMaxDist(distPX);
            return p;
        }
        return this.rebalanceTZ(p, x, distPX);
    }

    private Node<T> rebalanceTZ(Node<T> p, Node<T> x, double distPX) {
        ArrayList reinsert = null;
        x.initLevel(p.getLevel() - 1);
        if (p.hasChildren()) {
            ArrayList<Node<T>> children = p.getChildren();
            double covDist = this.covDist(p.getLevel() - 1);
            for (int i = 0; i < children.size(); ++i) {
                double distQX;
                Node<T> q = children.get(i);
                if (!q.hasChildren() || !((distQX = this.d(q, x)) <= 2.0 * covDist) || !(distQX <= covDist + q.maxdist(this))) continue;
                reinsert = reinsert != null ? reinsert : new ArrayList();
                this.rebalanceSub(x, q, reinsert, distQX);
            }
        }
        p.addChild(x, distPX);
        if (reinsert != null) {
            for (int i = 0; i < reinsert.size(); ++i) {
                Node q = (Node)reinsert.get(i);
                this.insert2NA(p, q, distPX);
            }
        }
        return p;
    }

    private void rebalanceSub(Node<T> x, Node<T> q, ArrayList<Node<T>> reinsert, double distQX) {
        if (q.hasChildren()) {
            ArrayList<Node<T>> children = q.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                double distRX;
                Node<T> r = children.get(i);
                double distRQ = r.getDistanceToParent();
                if (!(distRQ * 2.0 > distQX) || !((distRX = this.d(r, x)) < distRQ)) continue;
                q.removeChild(i--);
                this.reinsert(x, r, reinsert, distRX);
            }
        }
    }

    private void reinsert(Node<T> x, Node<T> rNew, ArrayList<Node<T>> reinsertLater, double distRX) {
        ArrayList<Node<T>> children = x.getOrCreateChildren();
        double covDistR = this.covdist(rNew);
        for (int i = 0; i < children.size(); ++i) {
            Node<T> rx = children.get(i);
            double distRxRNew = this.d(rx, rNew);
            if (!(distRxRNew < 2.0 * covDistR)) continue;
            if (distRxRNew < covDistR) {
                rNew.clearAndRemoveAllChildren(reinsertLater);
                reinsertLater.add(rNew);
                return;
            }
            if (!(rNew.maxdist(this) > distRxRNew - covDistR)) continue;
            rNew.clearAndRemoveAllChildren(reinsertLater);
        }
        if (distRX + rNew.maxdist(this) > this.covdist(x)) {
            rNew.clearAndRemoveAllChildren(reinsertLater);
        }
        x.addChild(rNew, distRX);
    }

    private Node<T> rebalance(Node<T> p, Node<T> q, Node<T> x, ArrayList<Node<T>> moveSet, ArrayList<Node<T>> staySet) {
        if (this.d(p, q) > this.d(q, x)) {
            if (q.hasChildren()) {
                ArrayList<Node<T>> children = q.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    Node<T> r = children.get(i);
                    if (this.d(r, p) > this.d(r, x)) {
                        moveSet.add(r);
                        continue;
                    }
                    staySet.add(r);
                }
            }
            return null;
        }
        Node<T> q0 = q;
        if (q.hasChildren()) {
            ArrayList<Node<T>> children = q.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Node<T> r = children.get(i);
                Node<T> r0 = this.rebalance(p, r, x, moveSet, staySet);
                if (r0 == null) {
                    q0 = q;
                    q0.removeChild(i);
                    continue;
                }
                q0 = q;
                q0.replaceChild(i, r0);
                q0.adjustMaxDist(this.d(q0, r0));
            }
        }
        for (int i = 0; i < staySet.size(); ++i) {
            Node<T> r = staySet.get(i);
            if (!(this.d(r, q0) <= this.covdist(q0))) continue;
            q0 = this.insert2(q0, r, this.d(r, q0));
            staySet.remove(i--);
        }
        return q0;
    }

    @Override
    public T remove(double[] point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T update(double[] oldPoint, double[] newPoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T queryExact(double[] point) {
        if (this.root == null) {
            return null;
        }
        Index.PointEntry<T> result = this.queryExact(this.root, point);
        return result == null ? null : (T)result.value();
    }

    private Index.PointEntry<T> queryExact(Node<T> p, double[] x) {
        if (Arrays.equals(p.point().point(), x)) {
            return p.point();
        }
        double distP = this.d(p.point(), x);
        if (distP > p.maxdist(this)) {
            return null;
        }
        ArrayList<Node<T>> children = p.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Node<T> q = children.get(i);
            Index.PointEntry<T> result = this.queryExact(q, x);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Index.PointIterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Index.PointIterator<T> query(double[] min, double[] max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Index.PointEntryKnn<T> query1nn(double[] center) {
        if (this.root == null) {
            return null;
        }
        Index.PointEntry<Object> x = new Index.PointEntry<Object>(center, null);
        double distPX = this.d(this.root.point(), center);
        ++this.nDist1NN;
        Index.PointEntryKnn<T> y = new Index.PointEntryKnn<T>(this.root.point().point(), this.root.point().value(), distPX);
        this.findNearestNeighbor(this.root, x, y, distPX);
        return y;
    }

    private void findNearestNeighbor(Node<T> p, Index.PointEntry<T> x, Index.PointEntryKnn<T> y, double distPX) {
        if (distPX < y.dist()) {
            y.set(p.point(), distPX);
        }
        if (p.hasChildren()) {
            ArrayList<Node<T>> children = p.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Node<T> q = children.get(i);
                double distPQ = q.getDistanceToParent();
                if (distPQ + q.maxdist(this) < distPX - y.dist() || distPQ - q.maxdist(this) > distPX + y.dist()) continue;
                double distQX = this.d(x, q.point());
                ++this.nDist1NN;
                if (!(y.dist() > distQX - q.maxdist(this))) continue;
                this.findNearestNeighbor(q, x, y, distQX);
            }
        }
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k) {
        return new KNNIterator(this).reset(center, k);
    }

    private void findNearestNeighbor(Node<T> p, double[] x, int k, ArrayList<Index.PointEntryKnn<T>> candidates, double distPX) {
        Index.PointEntry<T> nn = p.point();
        if (candidates.size() < k) {
            candidates.add(new Index.PointEntryKnn<T>(nn.point(), nn.value(), distPX));
            candidates.sort(comparator);
        } else if (distPX < candidates.get(k - 1).dist()) {
            candidates.remove(k - 1);
            candidates.add(new Index.PointEntryKnn<T>(nn.point(), nn.value(), distPX));
            candidates.sort(comparator);
        }
        if (p.hasChildren()) {
            ArrayList<Node<T>> children = p.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Node<T> q = children.get(i);
                double distCurrentWorst = candidates.get(candidates.size() - 1).dist();
                double distPQ = q.getDistanceToParent();
                if (distPQ + q.maxdist(this) < distPX - distCurrentWorst || distPQ - q.maxdist(this) > distPX + distCurrentWorst) continue;
                double distQX = this.d(q.point(), x);
                ++this.nDistKNN;
                if (!(distCurrentWorst > distQX - q.maxdist(this))) continue;
                this.findNearestNeighbor(q, x, k, candidates, distQX);
            }
        }
    }

    double d(Index.PointEntry<?> x, Index.PointEntry<?> y) {
        return this.d(x, y.point());
    }

    double d(Node<?> x, Node<?> y) {
        return this.d(x.point(), y.point().point());
    }

    private double d(Index.PointEntry<?> x, double[] p2) {
        ++this.nDistCalc;
        return this.dist.dist(x.point(), p2);
    }

    private double covdist(Node<?> p) {
        return this.covDist(p.getLevel());
    }

    private double covDist(int level) {
        return Math.pow(this.BASE, level);
    }

    @Override
    public boolean contains(double[] key) {
        return this.queryExact(key) != null;
    }

    public void check() {
        if (this.root != null) {
            CTStats stats = new CTStats(this);
            this.getStats(this.root, stats);
            if (stats.nEntries != this.nEntries) {
                throw new IllegalStateException("nEntries: " + stats.nEntries + " / " + this.nEntries);
            }
        }
    }

    private void getStats(Node<T> node, CTStats stats) {
        ++stats.nEntries;
        ++stats.nNodes;
        stats.minLevel = Math.min(stats.minLevel, node.getLevel());
        stats.maxLevel = Math.max(stats.maxLevel, node.getLevel());
        stats.maxDepth = stats.maxLevel - stats.minLevel;
        stats.sumLevel += (double)node.getLevel();
        if (node.hasChildren()) {
            double maxDist = -1.0;
            stats.maxNodeSize = Math.max(stats.maxNodeSize, node.getChildren().size());
            for (Node<T> c : node.getChildren()) {
                double distToParent = this.d(node, c);
                if (distToParent != c.getDistanceToParent()) {
                    throw new IllegalStateException("ParentDist: " + distToParent + " / " + c.getDistanceToParent());
                }
                if (node.getLevel() != c.getLevel() + 1) {
                    throw new IllegalStateException("Level: " + node.getLevel() + " / " + c.getLevel());
                }
                this.getStats(c, stats);
            }
            maxDist = this.getGlobalMaxDist(node);
            stats.sumMaxDist += maxDist;
            if (maxDist != node.maxdist(this)) {
                throw new IllegalStateException("Maxdist: " + maxDist + " / " + node.maxdist(this) + " Node:" + this.toStringNode(new StringBuilder(), node));
            }
            if (maxDist > this.covdist(node)) {
                throw new IllegalStateException("Maxdist/maxdist()/CovDist: " + maxDist + " / " + node.maxdist(this) + " / " + this.covdist(node));
            }
        } else {
            ++stats.nLeaf;
        }
    }

    private double getGlobalMaxDist(Node<T> node) {
        double currentMax = 0.0;
        if (node.hasChildren()) {
            for (Node<T> sub : node.getChildren()) {
                currentMax = this.getGlobalMaxDist(node, sub, currentMax);
            }
        }
        return currentMax;
    }

    private double getGlobalMaxDist(Node<T> p, Node<T> node, double currentMax) {
        double distOfThisNode = this.d(p, node);
        currentMax = Math.max(currentMax, distOfThisNode);
        if (node.hasChildren() && distOfThisNode + node.maxdist(this) > currentMax) {
            for (Node<T> sub : node.getChildren()) {
                currentMax = Math.max(currentMax, this.getGlobalMaxDist(p, sub, currentMax));
            }
        }
        return currentMax;
    }

    Node<T> getRoot() {
        return this.root;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ";BASE=" + this.BASE + ";NEAREST_ANCESTOR=true;DistFn=" + PointDistance.getName(this.dist);
    }

    public static class CTStats
    extends Stats {
        double sumMaxDist = 0.0;

        CTStats(CoverTree<?> tree) {
            super(tree.nDistCalc, tree.nDist1NN, tree.nDistKNN);
        }

        @Override
        public String toString() {
            return super.toString() + ";sumMaxDist=" + this.sumMaxDist;
        }
    }

    private static class KNNIterator<T>
    implements Index.PointIteratorKnn<T> {
        private final CoverTree<T> tree;
        private final ArrayList<Index.PointEntryKnn<T>> result = new ArrayList();
        private Iterator<Index.PointEntryKnn<T>> iter;

        public KNNIterator(CoverTree<T> tree) {
            this.tree = tree;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.PointEntryKnn<T> next() {
            return this.iter.next();
        }

        @Override
        public Index.PointIteratorKnn<T> reset(double[] center, int k) {
            this.result.clear();
            if (this.tree.root != null) {
                double distPX = this.tree.d(this.tree.root.point(), center);
                ++this.tree.nDistKNN;
                this.tree.findNearestNeighbor(this.tree.root, center, k, this.result, distPX);
            }
            this.iter = this.result.iterator();
            return this;
        }
    }
}

