/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.format;

import junit.framework.TestCase;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.format.Formater;
import org.tinygroup.format.PatternDefine;
import org.tinygroup.format.User;
import org.tinygroup.format.exception.FormatException;
import org.tinygroup.format.impl.DefaultPatternDefine;

public class FormatProviderTest
extends TestCase {
    ApplicationContext applicationContext = new ClassPathXmlApplicationContext("springbeans.xml");
    Context context = new ContextImpl();
    Formater formater = (Formater)this.applicationContext.getBean("formater");

    protected void setUp() throws Exception {
        super.setUp();
        this.context.clear();
    }

    public void testFormatNotPlaceholder() throws FormatException {
        FormatProviderTest.assertEquals((String)"this is test", (String)this.formater.format(this.context, "this is test"));
    }

    public void testFormatExistPlaceholderProvider() throws FormatException {
        ContextImpl context = new ContextImpl();
        FormatProviderTest.assertEquals((String)"this is v1 test", (String)this.formater.format((Context)context, "this is ${const:1} test"));
    }

    public void testFormatExistPlaceholderNoProvider() throws FormatException {
        FormatProviderTest.assertEquals((String)"this is ${abc:2} test", (String)this.formater.format(this.context, "this is ${abc:2} test"));
    }

    public void testFormatBean() throws FormatException {
        User user = new User("aa", 123);
        this.context.put("user", (Object)user);
        FormatProviderTest.assertEquals((String)"this is aa test 123", (String)this.formater.format(this.context, "this is ${context:user.name} test ${context:user.age}"));
    }

    public void testFormatPattern() {
        DefaultPatternDefine define = new DefaultPatternDefine();
        define.setPrefixPatternString("%{");
        define.setPostfixPatternString("}");
        define.setPatternString("([%]+[{]+[a-zA-Z0-9[.[_[:[/[#]]]]]]+[}])");
        this.formater.setPatternHandle((PatternDefine)define);
        FormatProviderTest.assertEquals((String)"this is v1 test v2", (String)this.formater.format(this.context, "this is %{const:1} test %{const:2}"));
    }
}

