/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.managementbu.plugin.service;

import java.util.List;

import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.plugin.PluginManager;
import org.tinygroup.plugin.config.PluginInfo;
import org.tinygroup.springutil.SpringUtil;

public class PluginManagerService {

	private PluginManager getPluginManager(){
		return SpringUtil.getBean("pluginManager");
	}
	
	/**
	 * 获取状态
	 * @param pluginInfo
	 * @return
	 */
	public int status(PluginInfo pluginInfo){
		return getPluginManager().status(pluginInfo);
	}
	
	/**
	 * 获取所有的plugin
	 * @return
	 */
	public List<PluginInfo> getAllPluginInfo(){
		PluginManager pluginManager = getPluginManager();
		return pluginManager.getAllPluginInfo();
	}
	
	/**
	 * 初始化单个plugin
	 * @param serviceId
	 */
	public void pluginInit(String serviceId){
		PluginManager pluginManager = getPluginManager();;
		if(StringUtil.isEmpty(serviceId)){
			pluginManager.init();
		}else{
			pluginManager.init(pluginManager.getPluginInfo(serviceId));
		}
	}
	
	/**
	 * 装配单个plugin
	 * @param serviceId
	 */
	public void pluginAssemble(String serviceId){
		PluginManager pluginManager = getPluginManager();;
		if(StringUtil.isEmpty(serviceId)){
			pluginManager.assemble();
		}else{
			pluginManager.assemble(pluginManager.getPluginInfo(serviceId));
		}
	}
	
	/**
	 * 拆装单个plugin
	 * @param serviceId
	 */
	public void pluginUnassemble(String serviceId){
		PluginManager pluginManager = getPluginManager();
		if(StringUtil.isEmpty(serviceId)){
			pluginManager.disassemble();
		}else{
			pluginManager.disassemble(pluginManager.getPluginInfo(serviceId));
		}
	}
	
	/**
	 * 停止单个plugin
	 * @param serviceId
	 */
	public void pluginStop(String serviceId){
		PluginManager pluginManager = getPluginManager();
		if(StringUtil.isEmpty(serviceId)){
			pluginManager.stop();
		}else{
			pluginManager.stop(pluginManager.getPluginInfo(serviceId));
		}
	}
	
	/**
	 * 启动单个plugin
	 * @param serviceId
	 */
	public void pluginStart(String serviceId){
		PluginManager pluginManager = getPluginManager();
		if(StringUtil.isEmpty(serviceId)){
			pluginManager.start();
		}else{
			pluginManager.start(pluginManager.getPluginInfo(serviceId));
		}
	}
	
	/**
	 * 停止单个plugin
	 * @param serviceId
	 */
	public void pluginDestroy(String serviceId){
		PluginManager pluginManager = getPluginManager();
		if(StringUtil.isEmpty(serviceId)){
			pluginManager.destroy();
		}else{
			pluginManager.destroy(pluginManager.getPluginInfo(serviceId));
		}
	}
	
	/**
	 * 暂停单个plugin
	 * @param serviceId
	 */
	public void pluginPause(String serviceId){
		PluginManager pluginManager = getPluginManager();
		if(StringUtil.isEmpty(serviceId)){
			pluginManager.pause();
		}else{
			pluginManager.pause(pluginManager.getPluginInfo(serviceId));
		}
		
	}
	
	/**
	 * 根据level初始化插件
	 * @param level
	 */
	public void pluginInitByLevel(Integer level){
		PluginManager pluginManager = getPluginManager();
		pluginManager.init(level);
	}
	
	/**
	 * 根据level装配插件
	 * @param level
	 */
	public void pluginAssembleByLevel(Integer level){
		PluginManager pluginManager = getPluginManager();
		pluginManager.assemble(level);
	}
	
	/**
	 * 根据level拆装插件
	 * @param level
	 */
	public void pluginUnassembleByLevel(Integer level){
		PluginManager pluginManager = getPluginManager();
		pluginManager.disassemble(level);
	}
	
	/**
	 * 根据level停止插件
	 * @param level
	 */
	public void pluginStopByLevel(Integer level){
		PluginManager pluginManager = getPluginManager();
		pluginManager.stop(level);
	}
	
	/**
	 * 根据level启动插件
	 * @param level
	 */
	public void pluginStartByLevel(Integer level){
		PluginManager pluginManager = getPluginManager();
		pluginManager.start(level);
	}
	
	/**
	 * 根据level暂停插件
	 * @param level
	 */
	public void pluginPauseByLevel(Integer level){
		PluginManager pluginManager = getPluginManager();
		pluginManager.pause(level);
	}
	
	/**
	 * 根据level销毁插件
	 * @param level
	 */
	public void pluginDestroyByLevel(Integer level){
		PluginManager pluginManager = getPluginManager();
		pluginManager.destroy(level);
	}
}
