/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.beanconverter;

import java.util.List;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context2object.ObjectAssembly;
import org.tinygroup.database.util.DataSourceInfo;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.tinydb.Bean;
import org.tinygroup.tinydb.util.TinyDBUtil;

public class BeanAssembly
implements ObjectAssembly<Bean> {
    private static final String SPLIT = ",";
    private static final String BEAN_TYPE_KEY = "@beantype";
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanAssembly.class);

    public void assemble(String varName, Bean object, Context context) {
        String beanType = (String)context.get(BEAN_TYPE_KEY);
        if (StringUtil.isBlank((String)beanType)) {
            LOGGER.errorMessage("\u672a\u8bbe\u7f6e\u53c2\u6570\u540d\u79f0\u4e3a@beantype\u7684\u53c2\u6570", new Object[0]);
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u53c2\u6570\u540d\u79f0\u4e3a@beantype\u7684\u53c2\u6570");
        }
        String[] types = beanType.split(SPLIT);
        String type = this.findType(varName, types);
        object.setType(type);
        String schema = DataSourceInfo.getDataSource();
        List properties = TinyDBUtil.getBeanProperties((String)beanType, (String)schema, (ClassLoader)this.getClass().getClassLoader());
        TinyDBUtil.context2Bean((Context)context, (Bean)object, (List)properties);
    }

    private String findType(String varName, String[] types) {
        if (types.length == 1) {
            return types[0];
        }
        return varName;
    }

    public boolean isMatch(Class<?> type) {
        return Bean.class.equals(type);
    }
}

