/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fulltext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fulltext.FullText;
import org.tinygroup.fulltext.IndexOperator;
import org.tinygroup.fulltext.Pager;
import org.tinygroup.fulltext.UserIndexOperator;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.document.HighlightDocument;
import org.tinygroup.fulltext.exception.FullTextException;
import org.tinygroup.fulltext.impl.AbstractFullText;

public class FullTextHelper {
    private static volatile String _id = "_id";
    private static volatile String _type = "_type";
    private static volatile String _title = "_title";
    private static volatile String _abstract = "_abstract";
    private static Map<String, FullText> dynmicMaps = new HashMap<String, FullText>();

    public static String getStoreId() {
        return _id;
    }

    public static void setStoreId(String id) {
        _id = id;
    }

    public static String getStoreType() {
        return _type;
    }

    public static void setStoreType(String type) {
        _type = type;
    }

    public static String getStoreTitle() {
        return _title;
    }

    public static void setStoreTitle(String title) {
        _title = title;
    }

    public static String getStoreAbstract() {
        return _abstract;
    }

    public static void setStoreAbstract(String Abstract) {
        _abstract = Abstract;
    }

    public static FullText getFullText() {
        String bean = ConfigurationUtil.getConfigurationManager().getConfiguration("FULLTEXT_BEAN_NAME");
        if (StringUtil.isEmpty((String)bean)) {
            throw new FullTextException(String.format("FullText\u7684bean\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5%s\u5168\u5c40\u914d\u7f6e\u53c2\u6570!", "FULLTEXT_BEAN_NAME"));
        }
        return (FullText)BeanContainerFactory.getBeanContainer((ClassLoader)FullTextHelper.class.getClassLoader()).getBean(bean);
    }

    public static synchronized FullText getFullText(String userId) {
        return FullTextHelper.getFullText(userId, null);
    }

    public static synchronized FullText getFullText(String userId, String configId) {
        FullText fulltext = dynmicMaps.get(userId);
        if (fulltext == null) {
            fulltext = FullTextHelper.createFullText(userId, configId);
            dynmicMaps.put(userId, fulltext);
        }
        return fulltext;
    }

    private static FullText createFullText(String userId, String configId) {
        String bean = ConfigurationUtil.getConfigurationManager().getConfiguration("FULLTEXT_DYNAMIC_BEAN");
        if (StringUtil.isEmpty((String)bean)) {
            throw new FullTextException(String.format("FullText\u7684bean\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5%s\u5168\u5c40\u914d\u7f6e\u53c2\u6570!", "FULLTEXT_DYNAMIC_BEAN"));
        }
        AbstractFullText fulltext = (AbstractFullText)BeanContainerFactory.getBeanContainer((ClassLoader)FullTextHelper.class.getClassLoader()).getBean(bean);
        IndexOperator indexOperator = fulltext.getIndexOperator();
        if (indexOperator == null) {
            throw new FullTextException(String.format("\u521b\u5efa\u52a8\u6001FullText\u5931\u8d25:\u5e95\u5c42\u64cd\u4f5c\u63a5\u53e3IndexOperator\u4e3a\u7a7a,\u8bf7\u68c0\u67e5%s\u5bf9\u5e94\u7684bean\u914d\u7f6e!", "FULLTEXT_DYNAMIC_BEAN"));
        }
        if (!(indexOperator instanceof UserIndexOperator)) {
            throw new FullTextException(String.format("\u521b\u5efa\u52a8\u6001FullText\u5931\u8d25:\u5e95\u5c42\u64cd\u4f5c\u63a5\u53e3%s\u4e0d\u652f\u6301UserIndexOperator,\u8bf7\u68c0\u67e5%s\u5bf9\u5e94\u7684bean\u914d\u7f6e!", indexOperator.getClass().getName(), "FULLTEXT_DYNAMIC_BEAN"));
        }
        UserIndexOperator userIndexOperator = (UserIndexOperator)indexOperator;
        userIndexOperator.setUserId(userId);
        userIndexOperator.setConfigId(configId);
        userIndexOperator.reset();
        return fulltext;
    }

    public static Pager<HighlightDocument> highlight(Pager<Document> pager, Object ... arguments) {
        if (pager == null) {
            return null;
        }
        ArrayList<HighlightDocument> list = new ArrayList<HighlightDocument>();
        if (pager.getRecords() != null) {
            for (Document doc : pager.getRecords()) {
                list.add(new HighlightDocument(doc, arguments));
            }
        }
        return new Pager<HighlightDocument>(pager.getTotalCount(), pager.getStart(), pager.getLimit(), list);
    }
}

