/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fulltext.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tinygroup.fulltext.FullTextHelper;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.field.Field;

public abstract class AbstractDocument
implements Document {
    protected List<Field> fields = new ArrayList<Field>();

    @Override
    public Iterator<Field> iterator() {
        return this.fields.iterator();
    }

    @Override
    public Field getId() {
        return this.getField(FullTextHelper.getStoreId());
    }

    @Override
    public Field getType() {
        return this.getField(FullTextHelper.getStoreType());
    }

    @Override
    public Field getTitle() {
        return this.getField(FullTextHelper.getStoreTitle());
    }

    @Override
    public Field getAbstract() {
        return this.getField(FullTextHelper.getStoreAbstract());
    }

    @Override
    public Field getField(String name) {
        for (Field field : this) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<Field> getFields(String name) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : this) {
            if (!field.getName().equals(name)) continue;
            result.add(field);
        }
        return result;
    }
}

