/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.httpclient451.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.context.Context;
import org.tinygroup.httpclient451.ssl.SimpleHostnameVerifier;
import org.tinygroup.httpvisitor.BodyElement;
import org.tinygroup.httpvisitor.Certifiable;
import org.tinygroup.httpvisitor.Cookie;
import org.tinygroup.httpvisitor.Header;
import org.tinygroup.httpvisitor.Request;
import org.tinygroup.httpvisitor.client.AbstractClientInterface;
import org.tinygroup.httpvisitor.client.ClientInterface;
import org.tinygroup.httpvisitor.execption.HttpVisitorException;
import org.tinygroup.httpvisitor.struct.KeyCert;
import org.tinygroup.httpvisitor.struct.Parameter;
import org.tinygroup.httpvisitor.struct.PasswordCert;
import org.tinygroup.httpvisitor.struct.Proxy;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

public abstract class AbstractHttpClient451
extends AbstractClientInterface
implements ClientInterface {
    private static final String DEFAULT_USER_AGENT = "HttpClient4.5.1";
    protected CloseableHttpClient httpClient;
    protected HttpClientContext httpClientContext;
    protected boolean allowRedirects;
    protected String userAgent;
    private HttpHost proxyHost = null;
    private CredentialsProvider credsProvider = null;
    private SSLConnectionSocketFactory sslsf = null;

    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public void init(Context context) {
        this.updateHttpConfigTemplate(context);
        this.httpClient = this.initHttpClient(context);
    }

    protected CloseableHttpClient initHttpClient(Context context) {
        this.allowRedirects = (Boolean)context.get("allowRedirect", (Object)true);
        this.userAgent = (String)context.get("User-Agent", (Object)DEFAULT_USER_AGENT);
        Proxy proxy = (Proxy)context.get("proxy");
        Certifiable cert = (Certifiable)context.get("cert");
        this.initProxy(proxy);
        this.initCertifiable(cert);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setUserAgent(this.userAgent).setSSLHostnameVerifier((HostnameVerifier)new SimpleHostnameVerifier());
        httpClientBuilder = httpClientBuilder.setConnectionManager(this.buildHttpClientConnectionManager(context));
        if (this.sslsf != null) {
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslsf);
        }
        CloseableHttpClient client = httpClientBuilder.build();
        this.initHttpClientContext(context);
        return client;
    }

    protected abstract HttpClientConnectionManager buildHttpClientConnectionManager(Context var1);

    protected void initHttpClientContext(Context context) {
        this.httpClientContext = HttpClientContext.create();
        this.httpClientContext.setCookieStore((CookieStore)new BasicCookieStore());
        Integer connectTime = (Integer)context.get("connectTimeOut");
        Integer socketTime = (Integer)context.get("socketTimeOut");
        RequestConfig.Builder builder = RequestConfig.custom().setRedirectsEnabled(this.allowRedirects).setProxy(this.proxyHost);
        if (connectTime != null) {
            builder.setConnectTimeout(connectTime.intValue());
        }
        if (socketTime != null) {
            builder.setSocketTimeout(socketTime.intValue());
        }
        RequestConfig requestConfig = builder.build();
        this.httpClientContext.setRequestConfig(requestConfig);
        this.httpClientContext.setCredentialsProvider(this.credsProvider);
    }

    protected void initProxy(Proxy proxy) {
        if (proxy != null) {
            this.proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            if (proxy.getProxyName() != null && proxy.getPassword() != null) {
                this.credsProvider = new BasicCredentialsProvider();
                this.credsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getProxyName(), proxy.getPassword()));
            }
        }
    }

    protected void initCertifiable(Certifiable cert) {
        if (cert != null) {
            if (cert instanceof KeyCert) {
                this.initKeyCert((KeyCert)cert);
            } else if (cert instanceof PasswordCert) {
                this.initPasswordCert((PasswordCert)cert);
            } else {
                throw new HttpVisitorException("\u672a\u77e5\u7684\u8ba4\u8bc1\u7c7b\u578b:" + cert.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKeyCert(KeyCert cert) {
        try {
            KeyStore keyStore = KeyStore.getInstance(cert.getCertType());
            FileObject certObjcet = VFS.resolveFile((String)cert.getCertPath());
            char[] password = cert.getPassword().toCharArray();
            try {
                keyStore.load(certObjcet.getInputStream(), password);
            }
            finally {
                certObjcet.clean();
            }
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(keyStore, password);
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(factory.getKeyManagers(), null, null);
            this.sslsf = new SSLConnectionSocketFactory(sslcontext);
        }
        catch (Exception e) {
            throw new HttpVisitorException("\u521d\u59cb\u5316\u8bc1\u4e66\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    protected void initPasswordCert(PasswordCert cert) {
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(new AuthScope("127.0.0.1", 443), (Credentials)new UsernamePasswordCredentials(cert.getUserName(), cert.getPassword()));
    }

    protected HttpRequestBase dealHttpMethod(Charset requestCharset, Request request) {
        HttpPost method = null;
        switch (request.getMethod()) {
            case GET: {
                method = new HttpGet(this.getUrl(request));
                break;
            }
            case POST: {
                method = new HttpPost(request.getUrl());
                this.addPostParameter((HttpRequestBase)method, requestCharset, request.getParameters());
                break;
            }
            case HEAD: {
                method = new HttpHead(this.getUrl(request));
                break;
            }
            case PUT: {
                method = new HttpPut(this.getUrl(request));
                break;
            }
            case PATCH: {
                method = new HttpPatch(this.getUrl(request));
                break;
            }
            case DELETE: {
                method = new HttpDelete(this.getUrl(request));
                break;
            }
            case OPTIONS: {
                method = new HttpOptions(this.getUrl(request));
                break;
            }
            case TRACE: {
                method = new HttpTrace(this.getUrl(request));
            }
        }
        return method;
    }

    private void addPostParameter(HttpRequestBase method, Charset requestCharset, List<Parameter> parameters) {
        try {
            if (!CollectionUtil.isEmpty(parameters)) {
                HttpEntityEnclosingRequestBase entityMethod = (HttpEntityEnclosingRequestBase)method;
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                for (Parameter parameter : parameters) {
                    params.add(new BasicNameValuePair(parameter.getName(), parameter.getValue().toString()));
                }
                entityMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params, requestCharset));
            }
        }
        catch (Exception e) {
            throw new HttpVisitorException("\u8f6c\u6362\u62a5\u6587\u7684\u5b57\u6bb5\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    protected void dealHeaders(HttpRequestBase method, List<Header> headers) {
        List templateHeaders;
        if (!CollectionUtil.isEmpty(headers)) {
            for (Header header : headers) {
                this.dealDefaultHeader(method, header.getName(), header.getValue());
            }
        }
        List list = templateHeaders = this.httpConfigTemplate == null ? null : this.httpConfigTemplate.getHeaderParamters();
        if (!CollectionUtil.isEmpty((Collection)templateHeaders)) {
            for (Header header : templateHeaders) {
                this.dealDefaultHeader(method, header.getName(), header.getValue());
            }
        }
        this.dealDefaultHeader(method, "User-Agent", this.userAgent);
    }

    private void dealDefaultHeader(HttpRequestBase method, String name, String value) {
        if (method.getFirstHeader(name) == null) {
            method.setHeader(name, value);
        }
    }

    protected void dealCookies(HttpRequestBase method, List<Cookie> cookies) {
        if (!CollectionUtil.isEmpty(cookies)) {
            for (Cookie cookie : cookies) {
                BasicClientCookie clientCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
                clientCookie.setDomain(cookie.getDomain() == null ? method.getURI().getHost() : cookie.getDomain());
                clientCookie.setPath(cookie.getPath() == null ? method.getURI().getPath() : cookie.getPath());
                clientCookie.setExpiryDate(cookie.getExpiryDate());
                clientCookie.setSecure(cookie.isSecure());
                this.httpClientContext.getCookieStore().addCookie((org.apache.http.cookie.Cookie)clientCookie);
            }
        }
    }

    protected void dealBodyElement(HttpRequestBase method, Charset requestCharset, List<BodyElement> bodyElements) {
        if (method instanceof HttpEntityEnclosingRequestBase && !CollectionUtil.isEmpty(bodyElements)) {
            HttpEntityEnclosingRequestBase entityMethod = (HttpEntityEnclosingRequestBase)method;
            try {
                if (bodyElements.size() == 1) {
                    BodyElement element = bodyElements.get(0);
                    this.dealSingleBodyElement(entityMethod, requestCharset, element);
                } else {
                    this.dealMultiBodyElement(entityMethod, requestCharset, bodyElements);
                }
            }
            catch (Exception e) {
                throw new HttpVisitorException("\u5904\u7406HTTP\u6b63\u6587\u53d1\u751f\u5f02\u5e38!", e);
            }
        }
    }

    private void dealSingleBodyElement(HttpEntityEnclosingRequestBase entityMethod, Charset requestCharset, BodyElement element) throws Exception {
        switch (element.getType()) {
            case STRING: {
                entityMethod.setEntity((HttpEntity)new StringEntity((String)element.getElement(), requestCharset));
                break;
            }
            case BYTEARRAY: {
                entityMethod.setEntity((HttpEntity)new ByteArrayEntity((byte[])element.getElement(), this.getContentType(element.getContentType(), ContentType.DEFAULT_BINARY)));
                break;
            }
            case INPUTSTREAM: {
                entityMethod.setEntity((HttpEntity)new InputStreamEntity((InputStream)element.getElement(), this.getContentType(element.getContentType(), ContentType.DEFAULT_BINARY)));
                break;
            }
            case FILE: {
                entityMethod.setEntity((HttpEntity)new FileEntity((File)element.getElement(), this.getContentType(element.getContentType(), ContentType.DEFAULT_BINARY)));
            }
        }
    }

    private void dealMultiBodyElement(HttpEntityEnclosingRequestBase entityMethod, Charset requestCharset, List<BodyElement> bodyElements) throws Exception {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (BodyElement element : bodyElements) {
            switch (element.getType()) {
                case STRING: {
                    entityBuilder.addTextBody(element.getName(), (String)element.getElement(), this.getContentType(element.getContentType(), ContentType.DEFAULT_TEXT));
                    break;
                }
                case BYTEARRAY: {
                    entityBuilder.addBinaryBody(element.getName(), (byte[])element.getElement(), this.getContentType(element.getContentType(), ContentType.DEFAULT_BINARY), element.getName());
                    break;
                }
                case INPUTSTREAM: {
                    entityBuilder.addBinaryBody(element.getName(), (InputStream)element.getElement(), this.getContentType(element.getContentType(), ContentType.DEFAULT_BINARY), element.getName());
                    break;
                }
                case FILE: {
                    File file = (File)element.getElement();
                    entityBuilder.addBinaryBody(element.getName(), file, this.getContentType(element.getContentType(), ContentType.DEFAULT_BINARY), file.getName());
                    break;
                }
            }
        }
        entityMethod.setEntity(entityBuilder.build());
    }

    private ContentType getContentType(String s, ContentType defaultType) {
        try {
            return s == null ? defaultType : ContentType.parse((String)s);
        }
        catch (Exception e) {
            return defaultType;
        }
    }
}

