/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.httpclient451.client;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.tinygroup.context.Context;
import org.tinygroup.httpclient451.client.AbstractHttpClient451;
import org.tinygroup.httpclient451.response.DefaultResponse;
import org.tinygroup.httpvisitor.Request;
import org.tinygroup.httpvisitor.Response;
import org.tinygroup.httpvisitor.execption.HttpVisitorException;

public class MultiClientImpl
extends AbstractHttpClient451 {
    public Response execute(Request request) {
        Charset requestCharset = this.getCharset(request);
        HttpRequestBase method = this.dealHttpMethod(requestCharset, request);
        this.dealHeaders(method, request.getHeaders());
        this.dealCookies(method, request.getCookies());
        this.dealBodyElement(method, requestCharset, request.getBodyElements());
        try {
            CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((HttpUriRequest)method, (HttpContext)this.httpClientContext);
            return new DefaultResponse(method, this.httpClientContext.getCookieStore(), closeableHttpResponse);
        }
        catch (ClientProtocolException e) {
            throw new HttpVisitorException("Http\u534f\u8bae\u6807\u8bc6\u5b58\u5728\u9519\u8bef", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new HttpVisitorException("Http\u901a\u8baf\u53d1\u751f\u5f02\u5e38", (Exception)e);
        }
    }

    public boolean allowMultiton() {
        return true;
    }

    @Override
    protected HttpClientConnectionManager buildHttpClientConnectionManager(Context context) {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        Integer maxTotalConnections = (Integer)context.get("maxTotalConnections");
        Integer maxConnectionsPerHost = (Integer)context.get("maxConnectionsPerHost");
        if (maxTotalConnections != null) {
            manager.setMaxTotal(maxTotalConnections.intValue());
        }
        if (maxConnectionsPerHost != null) {
            manager.setDefaultMaxPerRoute(maxConnectionsPerHost.intValue());
        }
        return manager;
    }
}

