/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.httpclient451.response;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.tinygroup.httpclient451.wrapper.CookieArrayWrapper;
import org.tinygroup.httpclient451.wrapper.HeaderArrayWrapper;
import org.tinygroup.httpclient451.wrapper.StatusLineWrapper;
import org.tinygroup.httpvisitor.Cookie;
import org.tinygroup.httpvisitor.Header;
import org.tinygroup.httpvisitor.Response;
import org.tinygroup.httpvisitor.StatusLine;
import org.tinygroup.httpvisitor.response.AbstractResponse;

public class DefaultResponse
extends AbstractResponse
implements Response {
    private HttpRequestBase method;
    private CookieStore cookieStore;
    private CloseableHttpResponse closeableHttpResponse;
    private StatusLine statusLine;

    public DefaultResponse(HttpRequestBase method, CookieStore cookieStore, CloseableHttpResponse closeableHttpResponse) {
        this.method = method;
        this.cookieStore = cookieStore;
        this.closeableHttpResponse = closeableHttpResponse;
    }

    public void close() throws IOException {
        this.closeableHttpResponse.close();
        this.method.abort();
    }

    public StatusLine getStatusLine() {
        if (this.statusLine == null) {
            this.statusLine = new StatusLineWrapper(this.closeableHttpResponse.getStatusLine());
        }
        return this.statusLine;
    }

    public Header[] getHeaders() {
        return new HeaderArrayWrapper(this.closeableHttpResponse.getAllHeaders()).getHeaders();
    }

    public Cookie[] getCookies() {
        return new CookieArrayWrapper(this.cookieStore.getCookies()).getCookies();
    }

    protected InputStream getSourceInputStream() throws IOException {
        return this.closeableHttpResponse.getEntity() == null ? null : this.closeableHttpResponse.getEntity().getContent();
    }

    protected Response self() {
        return this;
    }
}

