/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.localproperties.listener;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FileResolverFactory;
import org.tinygroup.fileresolver.FileResolverUtil;
import org.tinygroup.fileresolver.impl.I18nFileProcessor;
import org.tinygroup.fileresolver.impl.LocalPropertiesFileProcessor;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class LocalProSpringApplicationRunListener
implements SpringApplicationRunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalProSpringApplicationRunListener.class);
    String applicationConfig;

    public LocalProSpringApplicationRunListener(SpringApplication application, String[] args) {
    }

    public void starting() {
        LOGGER.infoMessage("\u5f00\u59cbLocalProSpringApplicationRunListener...", new Object[0]);
        InputStream inputStream = this.getClass().getResourceAsStream("/application.xml");
        try {
            this.applicationConfig = StreamUtil.readText((InputStream)inputStream, (String)"UTF-8", (boolean)true);
            this.startI18nProcess();
            ConfigurationManager c = ConfigurationUtil.getConfigurationManager();
            XmlNode applicationXml = (XmlNode)new XmlStringParser().parse(this.applicationConfig).getRoot();
            c.setApplicationConfiguration(applicationXml);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        LocalPropertiesFileProcessor localFileProcessor = new LocalPropertiesFileProcessor(this.applicationConfig);
        localFileProcessor.start();
    }

    private void startI18nProcess() {
        FileResolver fileResolver = FileResolverFactory.getFileResolver();
        FileResolverUtil.addClassPathPattern((FileResolver)fileResolver);
        this.loadFileResolverConfig(fileResolver, this.applicationConfig);
        fileResolver.addFileProcessor((FileProcessor)new I18nFileProcessor());
        fileResolver.resolve();
    }

    private void loadFileResolverConfig(FileResolver fileResolver, String applicationConfig) {
        XmlStringParser parser = new XmlStringParser();
        XmlNode root = (XmlNode)parser.parse(applicationConfig).getRoot();
        PathFilter filter = new PathFilter((Node)root);
        XmlNode appConfig = (XmlNode)filter.findNode("/application/file-resolver-configuration");
        fileResolver.config(appConfig, null);
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void finished(ConfigurableApplicationContext context, Throwable exception) {
    }
}

