/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.metadata.bizdatatype.BusinessTypeProcessor;
import org.tinygroup.metadata.config.bizdatatype.BusinessTypes;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class BusinessTypeFileResolver
extends AbstractFileProcessor {
    private static final String BIZDATATYPE_EXTFILENAME = ".bizdatatype.xml";
    private BusinessTypeProcessor businessTypeProcessor;

    public BusinessTypeProcessor getBusinessTypeProcessor() {
        return this.businessTypeProcessor;
    }

    public void setBusinessTypeProcessor(BusinessTypeProcessor businessTypeProcessor) {
        this.businessTypeProcessor = businessTypeProcessor;
    }

    public boolean isMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(BIZDATATYPE_EXTFILENAME) || fileObject.getFileName().endsWith(".bizdatatype");
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"metadata");
        for (FileObject fileObject : this.deleteList) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664bizdatatype\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            BusinessTypes businessTypes = (BusinessTypes)this.caches.get(fileObject.getAbsolutePath());
            if (businessTypes != null) {
                this.businessTypeProcessor.removeBusinessTypes(businessTypes);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            logger.logMessage(LogLevel.INFO, "\u79fb\u9664bizdatatype\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dbizdatatype\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            BusinessTypes oldBusinessTypes = (BusinessTypes)this.caches.get(fileObject.getAbsolutePath());
            if (oldBusinessTypes != null) {
                this.businessTypeProcessor.removeBusinessTypes(oldBusinessTypes);
            }
            BusinessTypes businessTypes = (BusinessTypes)stream.fromXML(fileObject.getInputStream());
            this.businessTypeProcessor.addBusinessTypes(businessTypes);
            this.caches.put(fileObject.getAbsolutePath(), businessTypes);
            logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dbizdatatype\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

