/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.metadata.config.stdfield.StandardFields;
import org.tinygroup.metadata.stdfield.StandardFieldProcessor;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class StandardFieldFileResolver
extends AbstractFileProcessor {
    private static final String STANDARDFIELD_EXTFILENAME = ".stdfield.xml";
    private StandardFieldProcessor standardFieldProcessor;

    public StandardFieldProcessor getStandardFieldProcessor() {
        return this.standardFieldProcessor;
    }

    public void setStandardFieldProcessor(StandardFieldProcessor standardFieldProcessor) {
        this.standardFieldProcessor = standardFieldProcessor;
    }

    public boolean isMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(STANDARDFIELD_EXTFILENAME) || fileObject.getFileName().endsWith(".stdfield");
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"metadata");
        for (FileObject fileObject : this.deleteList) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664stdfield\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            StandardFields standardFields = (StandardFields)this.caches.get(fileObject.getAbsolutePath());
            if (standardFields != null) {
                this.standardFieldProcessor.removeStandardFields(standardFields);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            logger.logMessage(LogLevel.INFO, "\u79fb\u9664stdfield\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dstdfield\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            StandardFields oldStandardFields = (StandardFields)this.caches.get(fileObject.getAbsolutePath());
            if (oldStandardFields != null) {
                this.standardFieldProcessor.removeStandardFields(oldStandardFields);
            }
            StandardFields standardFields = (StandardFields)stream.fromXML(fileObject.getInputStream());
            this.standardFieldProcessor.addStandardFields(standardFields);
            this.caches.put(fileObject.getAbsolutePath(), standardFields);
            logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dstdfield\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

