/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.metadata.config.stddatatype.StandardTypes;
import org.tinygroup.metadata.stddatatype.StandardTypeProcessor;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class StandardTypeFileResolver
extends AbstractFileProcessor {
    private static final String DATATYPE_EXTFILENAME = ".datatype.xml";
    private StandardTypeProcessor standardDataTypeProcessor;

    public StandardTypeProcessor getStandardDataTypeProcessor() {
        return this.standardDataTypeProcessor;
    }

    public void setStandardDataTypeProcessor(StandardTypeProcessor standardDataTypeProcessor) {
        this.standardDataTypeProcessor = standardDataTypeProcessor;
    }

    public boolean isMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(DATATYPE_EXTFILENAME) || fileObject.getFileName().endsWith(".datatype");
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"metadata");
        for (FileObject fileObject : this.deleteList) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664datatype\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            StandardTypes standardTypes = (StandardTypes)this.caches.get(fileObject.getAbsolutePath());
            if (standardTypes != null) {
                this.standardDataTypeProcessor.removeStandardTypes(standardTypes);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            logger.logMessage(LogLevel.INFO, "\u79fb\u9664datatype\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7ddatatype\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            StandardTypes oldStandardTypes = (StandardTypes)this.caches.get(fileObject.getAbsolutePath());
            if (oldStandardTypes != null) {
                this.standardDataTypeProcessor.removeStandardTypes(oldStandardTypes);
            }
            StandardTypes standardTypes = (StandardTypes)stream.fromXML(fileObject.getInputStream());
            this.standardDataTypeProcessor.addStandardTypes(standardTypes);
            this.caches.put(fileObject.getAbsolutePath(), standardTypes);
            logger.logMessage(LogLevel.INFO, "\u52a0\u8f7ddatatype\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

