/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.stdfield.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.metadata.bizdatatype.BusinessTypeProcessor;
import org.tinygroup.metadata.config.stdfield.NickName;
import org.tinygroup.metadata.config.stdfield.StandardField;
import org.tinygroup.metadata.config.stdfield.StandardFields;
import org.tinygroup.metadata.stdfield.StandardFieldProcessor;

public class StandardFieldProcessorImpl
implements StandardFieldProcessor {
    private static Map<String, StandardField> standardFieldMap = new HashMap<String, StandardField>();
    private static Map<String, String> nickIdMap = new HashMap<String, String>();
    BusinessTypeProcessor businessTypeProcessor;

    public BusinessTypeProcessor getBusinessTypeProcessor() {
        return this.businessTypeProcessor;
    }

    public void setBusinessTypeProcessor(BusinessTypeProcessor businessTypeProcessor) {
        this.businessTypeProcessor = businessTypeProcessor;
    }

    public StandardField getStandardField(String id) {
        String realId;
        if (standardFieldMap.containsKey(id)) {
            return standardFieldMap.get(id);
        }
        if (nickIdMap.containsKey(id) && standardFieldMap.containsKey(realId = nickIdMap.get(id))) {
            return standardFieldMap.get(realId);
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230ID\uff1a[%s]\u7684\u6807\u51c6\u5b57\u6bb5\u3002", id));
    }

    public void addStandardFields(StandardFields standardFields) {
        if (standardFields != null && standardFields.getStandardFieldList() != null) {
            for (StandardField field : standardFields.getStandardFieldList()) {
                standardFieldMap.put(field.getId(), field);
                if (field.getNickNames() == null) continue;
                for (NickName name : field.getNickNames()) {
                    nickIdMap.put(name.getId(), field.getId());
                }
            }
        }
    }

    public void removeStandardFields(StandardFields standardFields) {
        if (standardFields != null && standardFields.getStandardFieldList() != null) {
            for (StandardField field : standardFields.getStandardFieldList()) {
                standardFieldMap.remove(field.getId());
                if (field.getNickNames() == null) continue;
                for (NickName name : field.getNickNames()) {
                    nickIdMap.remove(name.getId());
                }
            }
        }
    }

    public String getType(String id, String language) {
        StandardField standardField = this.getStandardField(id);
        String type = this.businessTypeProcessor.getType(standardField.getTypeId(), language);
        if (type != null) {
            return type;
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230ID\uff1a[%s]\u7684\u6807\u51c6\u5b57\u6bb5\u5bf9\u5e94\u7684Language:[%s]\u7c7b\u578b\u3002", id, language));
    }
}

