/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.stdfield.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.metadata.bizdatatype.BusinessTypeProcessor;
import org.tinygroup.metadata.bizdatatype.impl.BusinessTypeProcessorImpl;
import org.tinygroup.metadata.config.stdfield.NickName;
import org.tinygroup.metadata.config.stdfield.StandardField;
import org.tinygroup.metadata.config.stdfield.StandardFields;
import org.tinygroup.metadata.stdfield.StandardFieldProcessor;

public class StandardFieldProcessorImpl
implements StandardFieldProcessor {
    private static Map<String, StandardField> standardFieldMap = new HashMap<String, StandardField>();
    BusinessTypeProcessor businessTypeProcessor;
    private static StandardFieldProcessor standardFieldProcessor = new StandardFieldProcessorImpl();

    public static StandardFieldProcessor getStandardFieldProcessor() {
        standardFieldProcessor.setBusinessTypeProcessor(BusinessTypeProcessorImpl.getBusinessTypeProcessor());
        return standardFieldProcessor;
    }

    public BusinessTypeProcessor getBusinessTypeProcessor() {
        return this.businessTypeProcessor;
    }

    public void setBusinessTypeProcessor(BusinessTypeProcessor businessTypeProcessor) {
        this.businessTypeProcessor = businessTypeProcessor;
    }

    public StandardField getStandardField(String id) {
        if (standardFieldMap.containsKey(id)) {
            return standardFieldMap.get(id);
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230ID\uff1a[%s]\u7684\u6807\u51c6\u5b57\u6bb5\u3002", id));
    }

    public void addStandardFields(StandardFields standardFields) {
        if (standardFields != null && standardFields.getStandardFieldList() != null) {
            for (StandardField field : standardFields.getStandardFieldList()) {
                standardFieldMap.put(field.getId(), field);
                if (field.getNickNames() == null) continue;
                for (NickName name : field.getNickNames()) {
                    StandardField newStandardField = new StandardField();
                    newStandardField.setId(name.getId());
                    newStandardField.setName(name.getName());
                    newStandardField.setTitle(name.getTitle());
                    newStandardField.setDefaultValue(field.getDefaultValue());
                    newStandardField.setDescription(field.getDescription());
                    newStandardField.setTypeId(field.getTypeId());
                    standardFieldMap.put(name.getId(), newStandardField);
                }
            }
        }
    }

    public void removeStandardFields(StandardFields standardFields) {
        if (standardFields != null && standardFields.getStandardFieldList() != null) {
            for (StandardField field : standardFields.getStandardFieldList()) {
                standardFieldMap.remove(field.getId());
                if (field.getNickNames() == null) continue;
                for (NickName name : field.getNickNames()) {
                    standardFieldMap.remove(name.getId());
                }
            }
        }
    }

    public String getType(String id, String language) {
        StandardField standardField = this.getStandardField(id);
        String type = this.businessTypeProcessor.getType(standardField.getTypeId(), language);
        if (type != null) {
            return type;
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230ID\uff1a[%s]\u7684\u6807\u51c6\u5b57\u6bb5\u5bf9\u5e94\u7684Language:[%s]\u7c7b\u578b\u3002", id, language));
    }
}

