/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.bizdatatype.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.metadata.bizdatatype.BusinessTypeProcessor;
import org.tinygroup.metadata.config.bizdatatype.BusinessType;
import org.tinygroup.metadata.config.bizdatatype.BusinessTypes;
import org.tinygroup.metadata.stddatatype.StandardTypeProcessor;
import org.tinygroup.metadata.stddatatype.impl.StandardTypeProcessorImpl;
import org.tinygroup.metadata.util.MetadataUtil;

public class BusinessTypeProcessorImpl
implements BusinessTypeProcessor {
    private static Map<String, BusinessType> businessTypeMap = new HashMap<String, BusinessType>();
    private StandardTypeProcessor standardTypeProcessor;
    private static BusinessTypeProcessor businessTypeProcessor = new BusinessTypeProcessorImpl();

    public static BusinessTypeProcessor getBusinessTypeProcessor() {
        businessTypeProcessor.setStandardTypeProcessor(StandardTypeProcessorImpl.getStandardTypeProcessor());
        return businessTypeProcessor;
    }

    public StandardTypeProcessor getStandardTypeProcessor() {
        return this.standardTypeProcessor;
    }

    public void setStandardTypeProcessor(StandardTypeProcessor standardDataTypeProcessor) {
        this.standardTypeProcessor = standardDataTypeProcessor;
    }

    public String getType(String id, String language) {
        BusinessType type = this.getBusinessTypes(id);
        String stdType = this.standardTypeProcessor.getType(type.getTypeId(), language);
        String result = MetadataUtil.formatType(stdType, type.getPlaceholderValueList());
        if (result != null) {
            return result;
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230ID:[%s]\u5bf9\u5e94\u7684\u4e1a\u52a1\u6570\u636e\u7c7b\u578b\u6240\u5c5e\u6807\u51c6\u6570\u636e\u7c7b\u578b\u4e2d\u7684\u8bed\u8a00\u7c7b\u578b:[%s]\u3002", id, language));
    }

    public void addBusinessTypes(BusinessTypes businessTypes) {
        if (businessTypes != null && businessTypes.getBusinessTypeList() != null) {
            for (BusinessType type : businessTypes.getBusinessTypeList()) {
                businessTypeMap.put(type.getId(), type);
            }
        }
    }

    public BusinessType getBusinessTypes(String id) {
        if (businessTypeMap.containsKey(id)) {
            return businessTypeMap.get(id);
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230ID:[%s]\u5bf9\u5e94\u7684\u4e1a\u52a1\u6570\u636e\u7c7b\u578b\u3002", id));
    }

    public void removeBusinessTypes(BusinessTypes businessTypes) {
        if (businessTypes != null && businessTypes.getBusinessTypeList() != null) {
            for (BusinessType type : businessTypes.getBusinessTypeList()) {
                businessTypeMap.remove(type.getId());
            }
        }
    }
}

