/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.stddatatype.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.metadata.config.stddatatype.DialectType;
import org.tinygroup.metadata.config.stddatatype.StandardType;
import org.tinygroup.metadata.config.stddatatype.StandardTypes;
import org.tinygroup.metadata.stddatatype.StandardTypeProcessor;
import org.tinygroup.metadata.util.MetadataUtil;

public class StandardTypeProcessorImpl
implements StandardTypeProcessor {
    private static Map<String, StandardType> standardMap = new HashMap<String, StandardType>();
    private static StandardTypeProcessor standardTypeProcessor = new StandardTypeProcessorImpl();

    public static StandardTypeProcessor getStandardTypeProcessor() {
        return standardTypeProcessor;
    }

    public String getType(String id, String language) {
        StandardType standardType = standardMap.get(id);
        if (standardType == null) {
            throw new RuntimeException(String.format("\u4e0d\u5b58\u5728, \u6807\u51c6\u7c7b\u578bID:[%s],\u8bed\u8a00:[%s]\u5bf9\u5e94\u7684\u6807\u51c6\u6570\u636e\u7c7b\u578b", id, language));
        }
        if (standardType.getDialectTypeList() != null) {
            for (DialectType dialectType : standardType.getDialectTypeList()) {
                if (!dialectType.getLanguage().equals(language)) continue;
                return MetadataUtil.formatType(dialectType.getType(), dialectType.getPlaceholderValueList());
            }
        }
        throw new RuntimeException(String.format("\u4e0d\u5b58\u5728, \u6807\u51c6\u7c7b\u578bID:[%s],\u8bed\u8a00:[%s]\u5bf9\u5e94\u7684\u7c7b\u578b ", id, language));
    }

    public void addStandardTypes(StandardTypes standardTypes) {
        if (standardTypes != null && standardTypes.getStandardTypeList() != null) {
            for (StandardType standardType : standardTypes.getStandardTypeList()) {
                standardMap.put(standardType.getId(), standardType);
            }
        }
    }

    public void removeStandardTypes(StandardTypes standardTypes) {
        if (standardTypes != null && standardTypes.getStandardTypeList() != null) {
            for (StandardType standardType : standardTypes.getStandardTypeList()) {
                standardMap.remove(standardType.getId());
            }
        }
    }

    public StandardType getStandardType(String id) {
        if (standardMap.containsKey(id)) {
            return standardMap.get(id);
        }
        throw new RuntimeException(String.format("\u4e0d\u5b58\u5728ID:[%s]\u5bf9\u5e94\u7684\u6807\u51c6\u6570\u636e\u7c7b\u578b ", id));
    }
}

