/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.metadata.config.constants.Constants;
import org.tinygroup.metadata.constants.ConstantProcessor;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class ConstantFileResolver
extends AbstractFileProcessor {
    private static final String CONSTANT_EXTFILENAME = ".const.xml";
    private ConstantProcessor constantProcessor;

    public ConstantProcessor getConstantProcessor() {
        return this.constantProcessor;
    }

    public void setConstantProcessor(ConstantProcessor constantProcessor) {
        this.constantProcessor = constantProcessor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"metadata");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664const\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Constants constants = (Constants)this.caches.get(fileObject.getAbsolutePath());
            if (constants != null) {
                this.constantProcessor.removeConstants(constants);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664const\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dconst\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Constants oldConstants = (Constants)this.caches.get(fileObject.getAbsolutePath());
            if (oldConstants != null) {
                this.constantProcessor.removeConstants(oldConstants);
            }
            Constants constants = (Constants)stream.fromXML(fileObject.getInputStream());
            this.constantProcessor.addConstants(constants);
            this.caches.put(fileObject.getAbsolutePath(), constants);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dconst\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(CONSTANT_EXTFILENAME) || fileObject.getFileName().endsWith(".const");
    }
}

