/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.metadata.config.errormessage.ErrorMessages;
import org.tinygroup.metadata.errormessage.ErrorMessageProcessor;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class ErrorMessageFileResolver
extends AbstractFileProcessor {
    private static final String ERROR_EXTFILENAME = ".error.xml";
    private ErrorMessageProcessor errorMessageProcessor;

    public ErrorMessageProcessor getErrorMessageProcessor() {
        return this.errorMessageProcessor;
    }

    public void setErrorMessageProcessor(ErrorMessageProcessor errorMessageProcessor) {
        this.errorMessageProcessor = errorMessageProcessor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"metadata");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664error\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            ErrorMessages errorMessages = (ErrorMessages)this.caches.get(fileObject.getAbsolutePath());
            if (errorMessages != null) {
                this.errorMessageProcessor.removeErrorMessages(errorMessages);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664error\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7derror\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            ErrorMessages oldErrorMessages = (ErrorMessages)this.caches.get(fileObject.getAbsolutePath());
            if (oldErrorMessages != null) {
                this.errorMessageProcessor.removeErrorMessages(oldErrorMessages);
            }
            ErrorMessages errorMessages = (ErrorMessages)stream.fromXML(fileObject.getInputStream());
            this.errorMessageProcessor.addErrorMessages(errorMessages);
            this.caches.put(fileObject.getAbsolutePath(), errorMessages);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7derror\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(ERROR_EXTFILENAME) || fileObject.getFileName().endsWith(".error");
    }
}

