/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.stddatatype.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.metadata.config.stddatatype.DialectType;
import org.tinygroup.metadata.config.stddatatype.StandardType;
import org.tinygroup.metadata.config.stddatatype.StandardTypes;
import org.tinygroup.metadata.exception.MetadataRuntimeException;
import org.tinygroup.metadata.stddatatype.StandardTypeProcessor;
import org.tinygroup.metadata.util.ConfigUtil;
import org.tinygroup.metadata.util.MetadataUtil;

public class StandardTypeProcessorImpl
implements StandardTypeProcessor {
    private static StandardTypeProcessor standardTypeProcessor = new StandardTypeProcessorImpl();
    private static Logger LOGGER = LoggerFactory.getLogger(StandardTypeProcessorImpl.class);
    private Map<String, StandardType> standardMap = new HashMap<String, StandardType>();

    public static StandardTypeProcessor getStandardTypeProcessor() {
        return standardTypeProcessor;
    }

    @Override
    public String getType(String id, String language) {
        StandardType standardType = this.standardMap.get(id);
        if (standardType == null) {
            throw new RuntimeException(String.format("\u4e0d\u5b58\u5728, \u6807\u51c6\u7c7b\u578bID:[%s],\u8bed\u8a00:[%s]\u5bf9\u5e94\u7684\u6807\u51c6\u6570\u636e\u7c7b\u578b", id, language));
        }
        return this.getType(standardType, language);
    }

    private String getType(StandardType standardType, String language) {
        if (standardType.getDialectTypeList() != null) {
            for (DialectType dialectType : standardType.getDialectTypeList()) {
                if (!dialectType.getLanguage().equals(language)) continue;
                return MetadataUtil.formatType(dialectType.getType(), dialectType.getPlaceholderValueList());
            }
        }
        throw new RuntimeException(String.format("\u4e0d\u5b58\u5728, \u6807\u51c6\u7c7b\u578bID:[%s],\u8bed\u8a00:[%s]\u5bf9\u5e94\u7684\u7c7b\u578b ", standardType.getId(), language));
    }

    @Override
    public void addStandardTypes(StandardTypes standardTypes) {
        if (standardTypes != null && standardTypes.getStandardTypeList() != null) {
            for (StandardType standardType : standardTypes.getStandardTypeList()) {
                if (this.standardMap.containsKey(standardType.getId())) {
                    if (ConfigUtil.isCheckStrict()) {
                        throw new MetadataRuntimeException("0TE120061001", standardType.getName(), standardType.getId());
                    }
                    LOGGER.error((Throwable)((Object)new MetadataRuntimeException("0TE120061001", standardType.getName(), standardType.getId())));
                    continue;
                }
                this.standardMap.put(standardType.getId(), standardType);
            }
        }
    }

    @Override
    public void removeStandardTypes(StandardTypes standardTypes) {
        if (standardTypes != null && standardTypes.getStandardTypeList() != null) {
            for (StandardType standardType : standardTypes.getStandardTypeList()) {
                this.standardMap.remove(standardType.getId());
            }
        }
    }

    @Override
    public StandardType getStandardType(String id) {
        if (this.standardMap.containsKey(id)) {
            return this.standardMap.get(id);
        }
        throw new MetadataRuntimeException("0TE120061002", id);
    }
}

