/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.defaultvalue.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.metadata.config.defaultvalue.DefaultValue;
import org.tinygroup.metadata.config.defaultvalue.DefaultValues;
import org.tinygroup.metadata.config.stddatatype.DialectType;
import org.tinygroup.metadata.defaultvalue.DefaultValueProcessor;
import org.tinygroup.metadata.exception.MetadataRuntimeException;
import org.tinygroup.metadata.util.ConfigUtil;

public class DefaultValueProcessorImpl
implements DefaultValueProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultValueProcessorImpl.class);
    private static DefaultValueProcessor defaultValueProcessor = new DefaultValueProcessorImpl();
    private Map<String, DefaultValue> defaultValueMap = new HashMap<String, DefaultValue>();

    public static DefaultValueProcessor getDefaultValueProcessor() {
        return defaultValueProcessor;
    }

    @Override
    public String getValue(String id, String language) {
        DefaultValue defaultValue = this.defaultValueMap.get(id);
        if (defaultValue == null) {
            throw new MetadataRuntimeException("0TE120061032", id, language);
        }
        if (defaultValue.getDialectTypeList() != null) {
            for (DialectType dialectType : defaultValue.getDialectTypeList()) {
                if (!dialectType.getLanguage().equals(language)) continue;
                return dialectType.getDefaultValue();
            }
        }
        throw new RuntimeException(String.format("\u4e0d\u5b58\u5728, \u9ed8\u8ba4\u503cID:[%s],\u8bed\u8a00:[%s]\u5bf9\u5e94\u7684\u9ed8\u8ba4\u503c\u5bf9\u8c61", id, language));
    }

    @Override
    public void addDefaultValues(DefaultValues defaultValues) {
        if (defaultValues != null && defaultValues.getDefaultValueList() != null) {
            for (DefaultValue defaultValue : defaultValues.getDefaultValueList()) {
                if (this.defaultValueMap.containsKey(defaultValue.getId())) {
                    if (ConfigUtil.isCheckStrict()) {
                        throw new MetadataRuntimeException("0TE120061031", defaultValue.getName(), defaultValue.getId());
                    }
                    LOGGER.error((Throwable)((Object)new MetadataRuntimeException("0TE120061031", defaultValue.getName(), defaultValue.getId())));
                }
                this.defaultValueMap.put(defaultValue.getId(), defaultValue);
            }
        }
    }

    @Override
    public DefaultValue getDefaultValue(String id) {
        if (this.defaultValueMap.containsKey(id)) {
            return this.defaultValueMap.get(id);
        }
        throw new RuntimeException(String.format("\u4e0d\u5b58\u5728ID:[%s]\u5bf9\u5e94\u7684\u9ed8\u8ba4\u503c ", id));
    }

    @Override
    public Map<String, DefaultValue> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    @Override
    public void removeDefaultValues(DefaultValues defaultValues) {
        if (defaultValues != null && defaultValues.getDefaultValueList() != null) {
            for (DefaultValue defaultValue : defaultValues.getDefaultValueList()) {
                this.defaultValueMap.remove(defaultValue.getId());
            }
        }
    }
}

