/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.errormessage.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.metadata.config.errormessage.ErrorMessage;
import org.tinygroup.metadata.config.errormessage.ErrorMessages;
import org.tinygroup.metadata.errormessage.ErrorMessageProcessor;
import org.tinygroup.metadata.util.MetadataUtil;

public class ErrorMessageProcessorImpl
implements ErrorMessageProcessor {
    private static ErrorMessageProcessor errorMessageProcessor = new ErrorMessageProcessorImpl();
    Map<String, ErrorMessages> errorMessageMap = new HashMap<String, ErrorMessages>();

    public static ErrorMessageProcessor getErrorMessageProcessor() {
        return errorMessageProcessor;
    }

    @Override
    public ErrorMessage getErrorMessage(String packageName, String name) {
        ErrorMessage errorMessage;
        if (packageName != null && (errorMessage = this.errorMessageMap.get(packageName).getErrorMessageMap().get(name)) != null) {
            return errorMessage;
        }
        for (String pkgName : this.errorMessageMap.keySet()) {
            ErrorMessage errorMessage2 = this.errorMessageMap.get(pkgName).getErrorMessageMap().get(name);
            if (errorMessage2 == null) continue;
            return errorMessage2;
        }
        throw new RuntimeException(String.format("package [%s] name [%s]\u7684\u9519\u8bef\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", packageName, name));
    }

    @Override
    public ErrorMessage getErrorMessage(String name) {
        return this.getErrorMessage(null, name);
    }

    @Override
    public void addErrorMessages(ErrorMessages errorMessages) {
        this.errorMessageMap.put(MetadataUtil.passNull(errorMessages.getPackageName()), errorMessages);
        Map<String, ErrorMessage> errorInfoMap = errorMessages.getErrorMessageMap();
        if (errorMessages.getErrorMessageList() != null) {
            for (ErrorMessage errorMessage : errorMessages.getErrorMessageList()) {
                errorInfoMap.put(errorMessage.getErrorId(), errorMessage);
            }
        }
    }

    @Override
    public void removeErrorMessages(ErrorMessages errorMessages) {
        this.errorMessageMap.remove(MetadataUtil.passNull(errorMessages.getPackageName()));
    }
}

