/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.config;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Map;
import org.tinygroup.metadata.config.ExtendProperties;

public class ExtendPropertyConverter
extends AbstractCollectionConverter {
    public ExtendPropertyConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type.equals(ExtendProperties.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        ExtendProperties map = (ExtendProperties)source;
        for (Map.Entry<String, String> entry : map.getExtendMap().entrySet()) {
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"property", Map.Entry.class);
            writer.addAttribute("key", entry.getKey().toString());
            writer.addAttribute("value", entry.getValue().toString());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ExtendProperties map = (ExtendProperties)this.createCollection(context.getRequiredType());
        this.populateMap(reader, context, map);
        return map;
    }

    protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, ExtendProperties map) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String key = reader.getAttribute("key");
            String value = reader.getAttribute("value");
            map.getExtendMap().put(key.toString(), value.toString());
            reader.moveUp();
        }
    }
}

