/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.metadata.config.dict.Dicts;
import org.tinygroup.metadata.dict.DictProcessor;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class DictFileProcessor
extends AbstractFileProcessor {
    private DictProcessor dictProcessor;

    public void setDictProcessor(DictProcessor dictProcessor) {
        this.dictProcessor = dictProcessor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"metadata");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664dict\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Dicts dicts = (Dicts)this.caches.get(fileObject.getAbsolutePath());
            if (dicts != null) {
                this.dictProcessor.removeDicts(dicts);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664dict\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7ddict\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Dicts oldDicts = (Dicts)this.caches.get(fileObject.getAbsolutePath());
            if (oldDicts != null) {
                this.dictProcessor.removeDicts(oldDicts);
            }
            Dicts dicts = (Dicts)this.convertFromXml(stream, fileObject);
            this.dictProcessor.addDicts(dicts);
            this.caches.put(fileObject.getAbsolutePath(), dicts);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7ddict\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith("dict") || fileObject.getFileName().endsWith("dict.xml");
    }
}

