/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.checkupdate;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.metadata.checkupdate.MetaDataFileInfo;
import org.tinygroup.metadata.checkupdate.MetaDataInfoContext;

public class MetaDataFileManager {
    public static final String TABLE_CREATE_SQL = "CREATE TABLE TINY_METADATA_RESOURCE (TYPE VARCHAR(20),RESOURCE_ID VARCHAR(32),MODIFIED_TIME  VARCHAR(20)) ";
    private static MetaDataFileManager metaDataFileManager = new MetaDataFileManager();
    private MetaDataInfoContext metaDataInfoContext = MetaDataInfoContext.getInstance();
    private List<String> insertSqls = new ArrayList<String>();
    private List<String> updateSqls = new ArrayList<String>();

    private MetaDataFileManager() {
    }

    public static MetaDataFileManager getInstance() {
        return metaDataFileManager;
    }

    public List<String> getInsertSqls() {
        return this.insertSqls;
    }

    public List<String> getUpdateSqls() {
        return this.updateSqls;
    }

    public void put(MetaDataFileInfo metaDataFileInfo) {
        this.metaDataInfoContext.put(metaDataFileInfo);
    }

    public List<MetaDataFileInfo> getMetaDataFileInfoList() {
        return this.metaDataInfoContext.getMetaDataFileInfoList();
    }

    public boolean createSqlAndCheckUpdate(MetaDataFileInfo metaDataFileInfo) {
        String key = metaDataFileInfo.getResourceId() + metaDataFileInfo.getType();
        if (!this.metaDataInfoContext.getKeys().contains(key)) {
            String formatSql = "insert into TINY_METADATA_RESOURCE(TYPE,RESOURCE_ID,MODIFIED_TIME) values('%s','%s','%s')";
            String sql = String.format(formatSql, metaDataFileInfo.getType(), metaDataFileInfo.getResourceId(), metaDataFileInfo.getModifiedTime());
            if (!this.insertSqls.contains(sql)) {
                this.insertSqls.add(sql);
            }
            return true;
        }
        if (!this.getMetaDataFileInfoList().contains(metaDataFileInfo)) {
            String formatSql = "update TINY_METADATA_RESOURCE set MODIFIED_TIME='%s' where TYPE='%s' and RESOURCE_ID='%s'";
            String sql = String.format(formatSql, metaDataFileInfo.getModifiedTime(), metaDataFileInfo.getType(), metaDataFileInfo.getResourceId());
            if (!this.updateSqls.contains(sql)) {
                this.updateSqls.add(sql);
            }
            return true;
        }
        return false;
    }
}

