/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.dict.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.metadata.config.dict.Dict;
import org.tinygroup.metadata.config.dict.Dicts;
import org.tinygroup.metadata.dict.DictProcessor;
import org.tinygroup.metadata.exception.MetadataRuntimeException;
import org.tinygroup.metadata.util.ConfigUtil;

public class DictProcessorImpl
implements DictProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictProcessorImpl.class);
    private static DictProcessor dictProcessor;
    private Map<String, Dict> dictMap = new HashMap<String, Dict>();

    public static DictProcessor getDictProcessor() {
        if (dictProcessor == null) {
            dictProcessor = new DictProcessorImpl();
        }
        return dictProcessor;
    }

    @Override
    public void removeDicts(Dicts dicts) {
        if (dicts != null && dicts.getDictList() != null) {
            for (Dict dict : dicts.getDictList()) {
                this.dictMap.remove(dict.getId());
            }
        }
    }

    @Override
    public void addDicts(Dicts dicts) {
        if (dicts != null && dicts.getDictList() != null) {
            for (Dict dict : dicts.getDictList()) {
                if (this.dictMap.containsKey(dict.getId())) {
                    if (ConfigUtil.isCheckStrict()) {
                        throw new MetadataRuntimeException("0TE120061051", dict.getName(), dict.getId());
                    }
                    LOGGER.error((Throwable)((Object)new MetadataRuntimeException("0TE120061051", dict.getName(), dict.getId())));
                }
                this.dictMap.put(dict.getId(), dict);
            }
        }
    }

    @Override
    public Dict getDict(String dictId) {
        Dict dict = this.dictMap.get(dictId);
        if (dict == null) {
            throw new MetadataRuntimeException("0TE120061052", dictId);
        }
        return dict;
    }

    @Override
    public Map<String, Dict> getDictMap() {
        return this.dictMap;
    }
}

