/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.metadata.config.defaultvalue.DefaultValues;
import org.tinygroup.metadata.defaultvalue.DefaultValueProcessor;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class DefaultValueFileResolver
extends AbstractFileProcessor {
    private static final String DEFAULTVALUE_EXTFILENAME = ".defaultvalue.xml";
    private DefaultValueProcessor defaultValueProcessor;

    public DefaultValueProcessor getDefaultValueProcessor() {
        return this.defaultValueProcessor;
    }

    public void setDefaultValueProcessor(DefaultValueProcessor defaultValueProcessor) {
        this.defaultValueProcessor = defaultValueProcessor;
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(DEFAULTVALUE_EXTFILENAME) || fileObject.getFileName().endsWith(".defaultvalue");
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"metadata");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664default\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            DefaultValues defaultValues = (DefaultValues)this.caches.get(fileObject.getAbsolutePath());
            if (defaultValues != null) {
                this.defaultValueProcessor.removeDefaultValues(defaultValues);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664default\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7ddefault\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            DefaultValues oldDefaultValues = (DefaultValues)this.caches.get(fileObject.getAbsolutePath());
            if (oldDefaultValues != null) {
                this.defaultValueProcessor.removeDefaultValues(oldDefaultValues);
            }
            DefaultValues defaultValues = (DefaultValues)this.convertFromXml(stream, fileObject);
            this.defaultValueProcessor.addDefaultValues(defaultValues);
            this.caches.put(fileObject.getAbsolutePath(), defaultValues);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7ddefault\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

