/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.stdfield.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.metadata.bizdatatype.BusinessTypeProcessor;
import org.tinygroup.metadata.bizdatatype.impl.BusinessTypeProcessorImpl;
import org.tinygroup.metadata.config.stdfield.NickName;
import org.tinygroup.metadata.config.stdfield.StandardField;
import org.tinygroup.metadata.config.stdfield.StandardFields;
import org.tinygroup.metadata.exception.MetadataRuntimeException;
import org.tinygroup.metadata.stdfield.StandardFieldProcessor;
import org.tinygroup.metadata.util.ConfigUtil;

public class StandardFieldProcessorImpl
implements StandardFieldProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(StandardFieldProcessorImpl.class);
    private static StandardFieldProcessor standardFieldProcessor = new StandardFieldProcessorImpl();
    BusinessTypeProcessor businessTypeProcessor;
    private Map<String, StandardField> standardFieldMap = new HashMap<String, StandardField>();

    public static StandardFieldProcessor getStandardFieldProcessor() {
        standardFieldProcessor.setBusinessTypeProcessor(BusinessTypeProcessorImpl.getBusinessTypeProcessor());
        return standardFieldProcessor;
    }

    @Override
    public BusinessTypeProcessor getBusinessTypeProcessor() {
        return this.businessTypeProcessor;
    }

    @Override
    public void setBusinessTypeProcessor(BusinessTypeProcessor businessTypeProcessor) {
        this.businessTypeProcessor = businessTypeProcessor;
    }

    @Override
    public StandardField getStandardField(String id) {
        if (this.standardFieldMap.containsKey(id)) {
            return this.standardFieldMap.get(id);
        }
        throw new MetadataRuntimeException("0TE120061022", id);
    }

    @Override
    public void addStandardFields(StandardFields standardFields) {
        if (standardFields != null && standardFields.getStandardFieldList() != null) {
            for (StandardField field : standardFields.getStandardFieldList()) {
                if (this.standardFieldMap.containsKey(field.getId())) {
                    if (ConfigUtil.isCheckStrict()) {
                        throw new MetadataRuntimeException("0TE120061021", field.getId());
                    }
                    LOGGER.error((Throwable)((Object)new MetadataRuntimeException("0TE120061021", field.getId())));
                    continue;
                }
                this.standardFieldMap.put(field.getId(), field);
                if (field.getNickNames() == null) continue;
                for (NickName name : field.getNickNames()) {
                    StandardField newStandardField = new StandardField();
                    newStandardField.setId(name.getId());
                    newStandardField.setName(name.getName());
                    newStandardField.setTitle(name.getTitle());
                    newStandardField.setDefaultValue(field.getDefaultValue());
                    newStandardField.setDescription(field.getDescription());
                    newStandardField.setTypeId(field.getTypeId());
                    this.standardFieldMap.put(name.getId(), newStandardField);
                }
            }
        }
    }

    @Override
    public void removeStandardFields(StandardFields standardFields) {
        if (standardFields != null && standardFields.getStandardFieldList() != null) {
            for (StandardField field : standardFields.getStandardFieldList()) {
                this.standardFieldMap.remove(field.getId());
                if (field.getNickNames() == null) continue;
                for (NickName name : field.getNickNames()) {
                    this.standardFieldMap.remove(name.getId());
                }
            }
        }
    }

    @Override
    public String getType(String id, String language) {
        StandardField standardField = this.getStandardField(id);
        String type = this.businessTypeProcessor.getType(standardField.getTypeId(), language);
        if (type != null) {
            return type;
        }
        throw new MetadataRuntimeException("0TE120061023", id, language);
    }
}

