/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.tinygroup.commons.tools.ValueUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context2object.util.Context2ObjectUtil;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.exception.ParamIsNullException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.Service;
import org.tinygroup.service.exception.ServiceExecuteException;
import org.tinygroup.service.exception.ServiceRunException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProxy
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceProxy.class);
    private Object objectInstance;
    private Method method;
    private List<Parameter> inputParameters;
    private Parameter outputParameter;
    private String methodName;
    private ClassLoader loader = this.getClass().getClassLoader();

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object getObjectInstance() {
        return this.objectInstance;
    }

    public void setObjectInstance(Object objectInstance) {
        this.objectInstance = objectInstance;
    }

    public Parameter getOutputParameter() {
        return this.outputParameter;
    }

    public void setOutputParameter(Parameter outputParameter) {
        this.outputParameter = outputParameter;
    }

    public List<Parameter> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(List<Parameter> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.methodName = method.getName();
    }

    private Class<?> getClassByName(Parameter param) {
        String name = param.getType();
        if (param.getCollectionType() != null) {
            name = param.getCollectionType();
        }
        Class<?> clazz = this.getClassByName(name);
        if (param.isArray()) {
            return Array.newInstance(clazz, 1).getClass();
        }
        return clazz;
    }

    private Class<?> getClassByName(String name) {
        try {
            if ("int".equals(name)) {
                return Integer.TYPE;
            }
            if ("byte".equals(name)) {
                return Byte.TYPE;
            }
            if ("long".equals(name)) {
                return Long.TYPE;
            }
            if ("short".equals(name)) {
                return Short.TYPE;
            }
            if ("char".equals(name)) {
                return Character.TYPE;
            }
            if ("double".equals(name)) {
                return Double.TYPE;
            }
            if ("float".equals(name)) {
                return Float.TYPE;
            }
            if ("boolean".equals(name)) {
                return Boolean.TYPE;
            }
            return this.loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceExecuteException(e);
        }
    }

    @Override
    public void execute(Context context) {
        LOGGER.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u6267\u884cserviceProxy,\u5bf9\u5e94\u65b9\u6cd5\u540d:{}", new Object[]{this.methodName});
        if (this.method == null) {
            this.method = this.findMethod();
        }
        LOGGER.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u83b7\u53d6\u65b9\u6cd5\u53c2\u6570");
        Object[] args = this.getArguments(context);
        LOGGER.logMessage(LogLevel.DEBUG, "\u53d6\u5f97\u65b9\u6cd5\u53c2\u6570");
        try {
            if (this.outputParameter != null && !this.outputParameter.getType().equals("void") && !this.outputParameter.getType().equals("")) {
                Object result = MethodUtils.invokeMethod((Object)this.objectInstance, (String)this.methodName, (Object[])args, (Class[])this.method.getParameterTypes());
                context.put(this.outputParameter.getName(), result);
            } else {
                MethodUtils.invokeMethod((Object)this.objectInstance, (String)this.methodName, (Object[])args, (Class[])this.method.getParameterTypes());
            }
        }
        catch (Exception e) {
            throw new ServiceRunException(e);
        }
        LOGGER.logMessage(LogLevel.DEBUG, "\u6267\u884cserviceProxy\u5b8c\u6bd5,\u5bf9\u5e94\u65b9\u6cd5\u540d:{}", new Object[]{this.methodName});
    }

    private Method findMethod() {
        Class[] argsType = null;
        if (this.inputParameters != null) {
            argsType = new Class[this.inputParameters.size()];
            for (int i = 0; i < argsType.length; ++i) {
                argsType[i] = this.getClassByName(this.inputParameters.get(i));
            }
        }
        try {
            return this.objectInstance.getClass().getMethod(this.methodName, argsType);
        }
        catch (Exception e) {
            LOGGER.errorMessage("\u83b7\u53d6\u65b9\u6cd5\u65f6\u51fa\u73b0\u5f02\u5e38,\u65b9\u6cd5\u540d:{methodName}", (Throwable)e, new Object[]{this.methodName});
            throw new RuntimeException("\u83b7\u53d6\u65b9\u6cd5\u65f6\u51fa\u73b0\u5f02\u5e38,\u65b9\u6cd5\u540d:{" + this.methodName + "}", e);
        }
    }

    private Object[] getArguments(Context context) {
        Object[] args = null;
        if (this.inputParameters != null && this.inputParameters.size() > 0) {
            args = new Object[this.inputParameters.size()];
            for (int i = 0; i < this.inputParameters.size(); ++i) {
                args[i] = this.getArgument(context, i);
            }
        }
        return args;
    }

    private Object getArgument(Context context, int i) {
        Parameter des = this.inputParameters.get(i);
        String paramName = des.getName();
        Object obj = Context2ObjectUtil.getObject((Parameter)des, (Context)context, (ClassLoader)this.loader);
        if (obj == null) {
            if (des.isRequired()) {
                LOGGER.logMessage(LogLevel.ERROR, "\u53c2\u6570{paramName}\u672a\u4f20\u9012", new Object[]{paramName});
                throw new ParamIsNullException(new Object[]{paramName});
            }
            return null;
        }
        if (!(obj instanceof String)) {
            return obj;
        }
        return ValueUtil.getValue((String)((String)obj), (String)des.getType());
    }
}

