/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.Configuration;
import org.tinygroup.event.Parameter;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.ServiceProxy;
import org.tinygroup.service.config.ServiceComponent;
import org.tinygroup.service.config.ServiceComponents;
import org.tinygroup.service.config.ServiceMethod;
import org.tinygroup.service.config.ServiceParameter;
import org.tinygroup.service.exception.ServiceLoadException;
import org.tinygroup.service.loader.ServiceLoader;
import org.tinygroup.service.registry.ServiceRegistry;
import org.tinygroup.service.registry.ServiceRegistryItem;
import org.tinygroup.service.release.ServiceReleaseManager;
import org.tinygroup.service.util.ServiceUtil;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlConfigServiceLoader
extends AbstractFileProcessor
implements ServiceLoader,
Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlConfigServiceLoader.class);
    private XmlNode applicationConfig;
    private XmlNode componentConfig;
    private static Map<String, Class<?>> classMap = new HashMap();

    @Override
    public void loadService(ServiceRegistry serviceRegistry, ClassLoader classLoader) throws ServiceLoadException {
        List<ServiceComponents> list = this.getServiceComponents();
        for (ServiceComponents serviceComponents : list) {
            this.loadService(serviceRegistry, serviceComponents, classLoader);
        }
    }

    @Override
    public void removeService(ServiceRegistry serviceRegistry, ClassLoader classLoader) {
        List<ServiceComponents> list = this.getServiceComponents();
        for (ServiceComponents serviceComponents : list) {
            this.removeServiceComponents(serviceRegistry, serviceComponents);
        }
    }

    public void removeServiceComponents(ServiceRegistry serviceRegistry, ServiceComponents serviceComponents) {
        for (ServiceComponent component : serviceComponents.getServiceComponents()) {
            for (ServiceMethod method : component.getServiceMethods()) {
                serviceRegistry.removeService(method.getServiceId());
            }
        }
    }

    private void loadService(ServiceRegistry serviceRegistry, ServiceComponents serviceComponents, ClassLoader classLoader) throws ServiceLoadException {
        for (ServiceComponent serviceComponent : serviceComponents.getServiceComponents()) {
            try {
                Object object = this.getServiceInstance(serviceComponent);
                this.registerServices(object, serviceComponent, serviceRegistry, classLoader);
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5b9e\u4f8b\u5316ServiceComponent\u65f6\u51fa\u73b0\u5f02\u5e38,\u7c7b\u540d:", (Throwable)e, new Object[]{serviceComponent.getType()});
            }
        }
    }

    private void registerServices(Object object, ServiceComponent serviceComponent, ServiceRegistry serviceRegistry, ClassLoader classLoader) throws ClassNotFoundException, ServiceLoadException {
        for (ServiceMethod serviceMethod : serviceComponent.getServiceMethods()) {
            String alias;
            if (!ServiceReleaseManager.isAccept(serviceMethod.getServiceId())) {
                LOGGER.logMessage(LogLevel.INFO, "\u8fc7\u6ee4\u670d\u52a1\uff1a{0}", new Object[]{serviceMethod.getServiceId()});
                continue;
            }
            ServiceRegistryItem item = new ServiceRegistryItem();
            item.setLocalName(serviceMethod.getLocalName());
            item.setDescription(serviceMethod.getDescription());
            item.setCategory(serviceMethod.getCategory());
            this.registerService(object, serviceMethod, item, classLoader);
            String serviceId = serviceMethod.getServiceId();
            if (!StringUtil.isBlank((String)serviceId)) {
                ServiceRegistryItem registryItem = ServiceUtil.copyServiceItem(item);
                registryItem.setServiceId(serviceId);
                serviceRegistry.registerService(registryItem);
            }
            if (StringUtil.isBlank((String)(alias = serviceMethod.getAlias()))) continue;
            ServiceRegistryItem registryItem = ServiceUtil.copyServiceItem(item);
            registryItem.setServiceId(alias);
            serviceRegistry.registerService(registryItem);
        }
    }

    private void registerService(Object object, ServiceMethod serviceMethod, ServiceRegistryItem item, ClassLoader classLoader) throws ClassNotFoundException, ServiceLoadException {
        ServiceProxy serviceProxy = new ServiceProxy();
        serviceProxy.setMethodName(serviceMethod.getMethodName());
        serviceProxy.setLoader(classLoader);
        serviceProxy.setObjectInstance(object);
        this.getInputParameterNames(item, serviceMethod, serviceProxy, classLoader);
        this.getOutputParameterNames(item, serviceMethod, serviceProxy, classLoader);
        item.setService(serviceProxy);
    }

    private void getInputParameterNames(ServiceRegistryItem item, ServiceMethod serviceMethod, ServiceProxy serviceProxy, ClassLoader classLoader) throws ClassNotFoundException, ServiceLoadException {
        ArrayList<Parameter> inputParameterDescriptors = new ArrayList<Parameter>();
        for (ServiceParameter serviceParameter : serviceMethod.getServiceParameters()) {
            String type = serviceParameter.getType();
            Class<?> parameterType = classMap.get(type);
            if (parameterType == null) {
                parameterType = classLoader.loadClass(type);
                classMap.put(type, parameterType);
            }
            Parameter descriptor = new Parameter();
            if (!ServiceUtil.assignFromSerializable(parameterType)) {
                throw new ServiceLoadException("\u670d\u52a1\u8fd4\u56de\u503c\u7c7b\u578b:<" + parameterType.getName() + ">\u5fc5\u987b\u5b9e\u73b0Serializable\u63a5\u53e3");
            }
            descriptor.setType(parameterType.getName());
            descriptor.setArray(serviceParameter.isArray());
            descriptor.setName(serviceParameter.getName());
            descriptor.setRequired(serviceParameter.isRequired());
            descriptor.setValidatorSence(serviceParameter.getValidatorScene());
            descriptor.setTitle(serviceParameter.getLocalName());
            descriptor.setCollectionType(serviceParameter.getCollectionType());
            descriptor.setDescription(serviceParameter.getDescription());
            inputParameterDescriptors.add(descriptor);
        }
        item.setParameters(inputParameterDescriptors);
        serviceProxy.setInputParameters(inputParameterDescriptors);
    }

    private void getOutputParameterNames(ServiceRegistryItem item, ServiceMethod serviceMethod, ServiceProxy serviceProxy, ClassLoader classLoader) throws ClassNotFoundException, ServiceLoadException {
        if (serviceMethod.getServiceResult() != null) {
            ServiceParameter serviceResult = serviceMethod.getServiceResult();
            String type = serviceResult.getType();
            Class<?> parameterType = classMap.get(type);
            if (parameterType == null) {
                parameterType = classLoader.loadClass(type);
                classMap.put(type, parameterType);
            }
            Parameter descriptor = new Parameter();
            if (!ServiceUtil.assignFromSerializable(parameterType)) {
                throw new ServiceLoadException("\u670d\u52a1\u8fd4\u56de\u503c\u7c7b\u578b:<" + parameterType.getName() + ">\u5fc5\u987b\u5b9e\u73b0Serializable\u63a5\u53e3");
            }
            descriptor.setType(parameterType.getName());
            descriptor.setArray(serviceResult.isArray());
            descriptor.setRequired(serviceResult.isRequired());
            descriptor.setName(serviceResult.getName());
            descriptor.setValidatorSence(serviceResult.getValidatorScene());
            descriptor.setTitle(serviceResult.getLocalName());
            descriptor.setDescription(serviceResult.getDescription());
            descriptor.setCollectionType(serviceResult.getCollectionType());
            serviceProxy.setOutputParameter(descriptor);
            ArrayList<Parameter> outputParameterDescriptors = new ArrayList<Parameter>();
            outputParameterDescriptors.add(descriptor);
            item.setResults(outputParameterDescriptors);
        }
    }

    Annotation getParameterAnnotation(Annotation[][] annotations, int index) {
        for (int i = 0; i < annotations[index].length; ++i) {
            if (!annotations[index][i].annotationType().equals(ServiceParameter.class)) continue;
            return annotations[index][i];
        }
        return null;
    }

    protected abstract List<ServiceComponents> getServiceComponents();

    protected abstract Object getServiceInstance(ServiceComponent var1) throws Exception;

    public String getApplicationNodePath() {
        return null;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public void process() {
    }

    static {
        classMap.put("int", Integer.TYPE);
        classMap.put("short", Short.TYPE);
        classMap.put("byte", Byte.TYPE);
        classMap.put("char", Character.TYPE);
        classMap.put("long", Long.TYPE);
        classMap.put("double", Double.TYPE);
        classMap.put("float", Float.TYPE);
        classMap.put("boolean", Boolean.TYPE);
        classMap.put("void", Void.TYPE);
    }
}

