/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.service.ServiceMappingManager;
import org.tinygroup.service.config.ServiceViewMappings;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class ServiceMappingFileProcessor
extends AbstractFileProcessor {
    private static final String SERVICEMAPPING_EXT_FILENAMES = ".servicemapping.xml";
    private ServiceMappingManager manager;

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(SERVICEMAPPING_EXT_FILENAMES);
    }

    public ServiceMappingManager getManager() {
        return this.manager;
    }

    public void setManager(ServiceMappingManager manager) {
        this.manager = manager;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"service");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728ServiceMappings\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            ServiceViewMappings mappings = (ServiceViewMappings)this.caches.get(fileObject.getAbsolutePath());
            if (mappings != null) {
                this.manager.removeServiceMappings(mappings);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6ServiceMappings\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728ServiceMappings\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            ServiceViewMappings oldMappings = (ServiceViewMappings)this.caches.get(fileObject.getAbsolutePath());
            if (oldMappings != null) {
                this.manager.removeServiceMappings(oldMappings);
            }
            InputStream inputStream = fileObject.getInputStream();
            ServiceViewMappings mappings = (ServiceViewMappings)stream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            this.manager.addServiceMappings(mappings);
            this.caches.put(fileObject.getAbsolutePath(), mappings);
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6ServiceMappings\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

