/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.service.ServiceMappingManager;
import org.tinygroup.service.config.ServiceViewMapping;
import org.tinygroup.service.config.ServiceViewMappings;

public class ServiceMappingManagerImpl
implements ServiceMappingManager {
    Map<String, String> urlMapping = new HashMap<String, String>();
    Map<String, ServiceViewMapping> viewMapping = new HashMap<String, ServiceViewMapping>();

    public void addServiceMappings(ServiceViewMappings mappings) {
        for (ServiceViewMapping mapping : mappings.getServiceViewMappings()) {
            this.urlMapping.put(mapping.getServiceId(), mapping.getPath());
            this.viewMapping.put(mapping.getServiceId(), mapping);
        }
    }

    public void removeServiceMappings(ServiceViewMappings mappings) {
        for (ServiceViewMapping mapping : mappings.getServiceViewMappings()) {
            this.urlMapping.remove(mapping.getServiceId());
            this.viewMapping.remove(mapping.getServiceId());
        }
    }

    public String getUrl(String serviceId) {
        return this.urlMapping.get(serviceId);
    }

    public void addServiceMapping(ServiceViewMapping mapping) {
        if (mapping != null) {
            this.urlMapping.put(mapping.getServiceId(), mapping.getPath());
            this.viewMapping.put(mapping.getServiceId(), mapping);
        }
    }

    public ServiceViewMapping getServiceViewMapping(String serviceId) {
        return this.viewMapping.get(serviceId);
    }
}

