/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.release;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tinygroup.service.release.config.ServiceRelease;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReleaseManager {
    private static Set<String> excludes = new HashSet<String>();
    private static Set<String> includes = new HashSet<String>();

    public static void add(ServiceRelease releaseInfo) {
        if (releaseInfo.getExcludes() != null) {
            for (String item : releaseInfo.getExcludes().getItems()) {
                excludes.add(item);
            }
        }
        if (releaseInfo.getIncludes() != null) {
            for (String item : releaseInfo.getIncludes().getItems()) {
                includes.add(item);
            }
        }
    }

    public static void clear() {
        excludes.clear();
        includes.clear();
    }

    public static void reload(List<ServiceRelease> list) {
        ServiceReleaseManager.clear();
        for (ServiceRelease releaseInfo : list) {
            ServiceReleaseManager.add(releaseInfo);
        }
    }

    public static boolean isAccept(String serviceId) {
        if (excludes.size() == 0 && includes.size() == 0) {
            return true;
        }
        if (excludes.size() > 0) {
            return !excludes.contains(serviceId);
        }
        return includes.contains(serviceId);
    }
}

