/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.util;

import java.util.List;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.event.Parameter;
import org.tinygroup.service.exception.ServiceParamValidateException;
import org.tinygroup.validate.ValidateResult;
import org.tinygroup.validate.ValidatorManager;
import org.tinygroup.validate.XmlValidatorManager;
import org.tinygroup.validate.impl.ValidateResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamValidate {
    public static void validate(Object[] args, List<Parameter> inputParameters) {
        ValidateResultImpl result = new ValidateResultImpl();
        for (int i = 0; i < inputParameters.size(); ++i) {
            Parameter p = inputParameters.get(i);
            Object value = args[i];
            String scenes = p.getValidatorSence();
            if (scenes == null || "".equals(scenes)) continue;
            ValidatorManager xmlValidatorManager = (ValidatorManager)BeanContainerFactory.getBeanContainer((ClassLoader)ParamValidate.class.getClassLoader()).getBean(XmlValidatorManager.class);
            if (p.isArray()) {
                Object[] array = (Object[])value;
                ParamValidate.validateArray(scenes, array, (ValidateResult)result, xmlValidatorManager);
                continue;
            }
            if (value instanceof List) {
                ParamValidate.validateList(scenes, (List)value, (ValidateResult)result, xmlValidatorManager);
                continue;
            }
            ParamValidate.validateObject(scenes, value, (ValidateResult)result, xmlValidatorManager);
        }
        if (result.hasError()) {
            throw new ServiceParamValidateException((ValidateResult)result);
        }
    }

    private static void validateList(String scene, List value, ValidateResult result, ValidatorManager xmlValidatorManager) {
        Object[] array;
        for (Object o : array = value.toArray()) {
            ParamValidate.validateObject(scene, o, result, xmlValidatorManager);
        }
    }

    private static void validateArray(String scene, Object[] value, ValidateResult result, ValidatorManager xmlValidatorManager) {
        for (Object o : value) {
            ParamValidate.validateObject(scene, o, result, xmlValidatorManager);
        }
    }

    private static void validateObject(String scene, Object value, ValidateResult result, ValidatorManager xmlValidatorManager) {
        xmlValidatorManager.validate(scene, value, result);
    }
}

