/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.aop;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.service.ServiceProxy;
import org.tinygroup.service.aop.ServiceAopAdapter;
import org.tinygroup.xmlparser.node.XmlNode;

public class ServiceAopManager {
    public static final String SERVICE_AOP_BEFORE = "before";
    public static final String SERVICE_AOP_AFTER = "after";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceAopManager.class);
    private static ServiceAopManager manager = new ServiceAopManager();
    private List<ServiceAopAdapter> beforeList = new ArrayList<ServiceAopAdapter>();
    private List<ServiceAopAdapter> beforeEnableList = new ArrayList<ServiceAopAdapter>();
    private List<ServiceAopAdapter> afterList = new ArrayList<ServiceAopAdapter>();
    private List<ServiceAopAdapter> afterEnableList = new ArrayList<ServiceAopAdapter>();

    private ServiceAopManager() {
    }

    public static ServiceAopManager getInstance() {
        return manager;
    }

    public void setConfig(XmlNode config) {
        if (config == null) {
            return;
        }
        NameFilter nameFilter = new NameFilter((Node)config);
        List aopList = nameFilter.findNodeList("aop-config");
        for (XmlNode node : aopList) {
            String postion = node.getAttribute("position");
            if (postion.equals(SERVICE_AOP_BEFORE)) {
                this.dealAopConfig(node, this.beforeList, this.beforeEnableList);
                continue;
            }
            this.dealAopConfig(node, this.afterList, this.afterEnableList);
        }
    }

    private void dealAopConfig(XmlNode node, List<ServiceAopAdapter> allList, List<ServiceAopAdapter> enbaleList) {
        String bean = node.getAttribute("bean");
        String enable = node.getAttribute("enable");
        try {
            ServiceAopAdapter adapter = (ServiceAopAdapter)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(bean);
            allList.add(adapter);
            if (enable == null || "true".equals(enable)) {
                enbaleList.add(adapter);
            }
        }
        catch (Exception e) {
            LOGGER.errorMessage("\u6dfb\u52a0ServiceAopAdapter\u65f6\u51fa\u73b0\u5f02\u5e38,bean:{0},enable:{1}", (Throwable)e, new Object[]{bean, enable});
        }
    }

    public void beforeHandle(Object[] args, ServiceProxy sp) {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u6267\u884cSerciveAop\u524d\u7f6e\u5904\u7406\u5668");
        for (int i = 0; i < this.beforeEnableList.size(); ++i) {
            ServiceAopAdapter adapter = this.beforeEnableList.get(i);
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u6267\u884cSerciveAop\u524d\u7f6e\u5904\u7406\u5668{0}", new Object[]{adapter.getClass().toString()});
            adapter.handle(args, sp);
            LOGGER.logMessage(LogLevel.INFO, "\u6267\u884cSerciveAop\u524d\u7f6e\u5904\u7406\u5668{0}\u5b8c\u6210", new Object[]{adapter.getClass().toString()});
        }
        LOGGER.logMessage(LogLevel.INFO, "\u6267\u884cSerciveAop\u524d\u7f6e\u5904\u7406\u5668\u5b8c\u6210");
    }

    public void afterHandle(Object[] args, ServiceProxy sp) {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u6267\u884cSerciveAop\u540e\u7f6e\u5904\u7406\u5668");
        for (int i = 0; i < this.afterEnableList.size(); ++i) {
            ServiceAopAdapter adapter = this.afterEnableList.get(i);
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u6267\u884cSerciveAop\u540e\u7f6e\u5904\u7406\u5668{0}", new Object[]{adapter.getClass().toString()});
            adapter.handle(args, sp);
            LOGGER.logMessage(LogLevel.INFO, "\u6267\u884cSerciveAop\u540e\u7f6e\u5904\u7406\u5668{0}\u5b8c\u6210", new Object[]{adapter.getClass().toString()});
        }
        LOGGER.logMessage(LogLevel.INFO, "\u6267\u884cSerciveAop\u540e\u7f6e\u5904\u7406\u5668\u5b8c\u6210");
    }

    public List<ServiceAopAdapter> getBeforeList() {
        return this.beforeList;
    }

    public List<ServiceAopAdapter> getBeforeEnableList() {
        return this.beforeEnableList;
    }

    public List<ServiceAopAdapter> getAfterList() {
        return this.afterList;
    }

    public List<ServiceAopAdapter> getAfterEnableList() {
        return this.afterEnableList;
    }
}

